<?php

if ( ! session_id() ) {
	session_start();
}

if ( ! defined( 'ABSPATH' ) ) {
	exit; // restict for direct access
}



if ( ! class_exists( 'Front_Class_Addify_Customer_And_Role_Pricing' ) ) {

	class Front_Class_Addify_Customer_And_Role_Pricing extends Addify_Customer_And_Role_Pricing {

		public function __construct() {

			add_action( 'init', array( $this, 'csp_load' ) );
			add_action( 'wp_loaded', array( $this, 'csp_front_scripts' ) );

			// Simple Products
			// Change Price HTML
			add_filter( 'woocommerce_get_price_html', array( $this, 'af_csp_custom_price_html' ), 100, 2 );
			
			add_filter( 'woocommerce_get_sale_price_html', array( $this, 'af_csp_custom_price_html' ), 100, 2 );

			add_filter( 'woocommerce_product_get_price', array( $this, 'af_csp_price_adjustment' ), 99, 2 );

			// Variable Products
			// Chagen Price HTML
			add_filter( 'woocommerce_variable_price_html', array( $this, 'af_csp_custom_price_html' ), 10, 2 );
			add_filter( 'woocommerce_variable_sale_price_html', array( $this, 'af_csp_custom_price_html' ), 10, 2 );

			// Variable Products
			add_filter( 'woocommerce_product_variation_get_regular_price', array( $this, 'af_csp_custom_price' ), 99, 2 );
			add_filter( 'woocommerce_product_variation_get_price', array( $this, 'af_csp_price_adjustment' ), 99, 2 );
			// Variable (price range)
			add_filter( 'woocommerce_variation_prices_price', array( $this, 'af_csp_custom_price_variation_product_level' ), 99, 3 );
			add_filter( 'woocommerce_variation_prices_regular_price', array( $this, 'af_csp_custom_price_variation_product_level' ), 99, 3 );

			add_filter( 'woocommerce_get_variation_prices_hash', array( $this, 'add_user_id_to_woocommerce_get_variation_prices_hash' ) );

			// Min and Max Qty validation
			add_filter( 'woocommerce_add_to_cart_validation', array( $this, 'csp_validate_min_max_qty' ), 10, 4 );

			// Update Cart validation
			add_filter( 'woocommerce_update_cart_validation', array( $this, 'csp_update_cart_quantity_validation' ), 10, 4 );

			// Hide add to cart shop page.
			add_filter( 'woocommerce_loop_add_to_cart_link', array( $this, 'csp_replace_loop_add_to_cart_link' ), 10, 2 );

			// Hide add to cart on product page.
			add_action( 'woocommerce_single_product_summary', array( $this, 'csp_hide_add_cart_product_page' ), 1, 0 );

		}

		public function csp_load() {

			if ( ! empty( $_SESSION['allfetchedrules'] ) ) {

				// get Rules
				$new_args = array(
					'post_type'   => 'csp_rules',
					'post_status' => 'publish',
					'orderby'     => 'menu_order',
					'numberposts' => -1,
				);

				$all_new_rules = get_posts( $new_args );

				$old_array = count( $_SESSION['allfetchedrules'] );

				$new_array = count( $all_new_rules );

				if ( 0 == $new_array ) {

					if ( ! empty( $_SESSION['allfetchedrules'] ) ) {

						$_SESSION['allfetchedrules'] = '';
					}
				}

				if ( $new_array > $old_array ) {

					// get Rules
					$args = array(
						'post_type'   => 'csp_rules',
						'post_status' => 'publish',
						'orderby'     => 'menu_order',
						'numberposts' => -1,
					);

					$all_new_rules = get_posts( $args );

					if ( empty( $all_new_rules ) ) {

						unset( $_SESSION['allfetchedrules'] );
					}

					foreach ( $all_new_rules as $rule ) {

						if ( ! empty( get_post_meta( $rule->ID, 'csp_applied_on_products', true ) ) ) {
							$products = get_post_meta( $rule->ID, 'csp_applied_on_products', true );
						} else {
							$products = array();
						}

						$categories = get_post_meta( $rule->ID, 'csp_applied_on_categories', true );

						$pri_pros = array();

						$new_array = array();

						if ( ! empty( $categories ) ) {

							$product_args = array(
								'numberposts' => -1,
								'post_status' => array( 'publish' ),
								'post_type'   => array( 'product' ), // skip types
							);

							$product_args['tax_query'] = array(
								array(
									'taxonomy' => 'product_cat',
									'field'    => 'id',
									'terms'    => $categories,
									'operator' => 'IN',
								),
							);

							$products_ids = get_posts( $product_args );

							foreach ( $products_ids as $proid ) {
								$pri_pros[] = $proid->ID;
							}
						}

						$new_array = array_unique( array_merge( $products, $pri_pros ) );

						$rule->ProductsSession = $new_array;
						$all_new_rules_new[]   = $rule;

					}

					$_SESSION['allfetchedrules'] = $all_new_rules_new;

				} else {

					foreach ( $_SESSION['allfetchedrules'] as $rule ) {

						if ( ! empty( get_post_meta( $rule->ID, 'csp_applied_on_products', true ) ) ) {
							$products = get_post_meta( $rule->ID, 'csp_applied_on_products', true );
						} else {
							$products = array();
						}

						$categories = get_post_meta( $rule->ID, 'csp_applied_on_categories', true );

						$pri_pros = array();

						$new_array = array();

						if ( ! empty( $categories ) ) {

							$product_args = array(
								'numberposts' => -1,
								'post_status' => array( 'publish' ),
								'post_type'   => array( 'product' ), // skip types
							);

							$product_args['tax_query'] = array(
								array(
									'taxonomy' => 'product_cat',
									'field'    => 'id',
									'terms'    => $categories,
									'operator' => 'IN',
								),
							);

							$products_ids = get_posts( $product_args );

							foreach ( $products_ids as $proid ) {
								$pri_pros[] = $proid->ID;
							}
						}

						$new_array = array_unique( array_merge( $products, $pri_pros ) );

						$rule->ProductsSession = $new_array;
						$all_new_rules_new[]   = $rule;

					}

					$_SESSION['allfetchedrules'] = $all_new_rules_new;
				}
			}

			// If session is empty then populate the session
			if ( empty( $_SESSION['allfetchedrules'] ) ) {
				// get Rules
				$args = array(
					'post_type'   => 'csp_rules',
					'post_status' => 'publish',
					'orderby'     => 'menu_order',
					'numberposts' => -1,
				);

				$all_new_rules = get_posts( $args );

				foreach ( $all_new_rules as $rule ) {

					if ( ! empty( get_post_meta( $rule->ID, 'csp_applied_on_products', true ) ) ) {
						$products = get_post_meta( $rule->ID, 'csp_applied_on_products', true );
					} else {
						$products = array();
					}

					$categories = get_post_meta( $rule->ID, 'csp_applied_on_categories', true );

					$pri_pros = array();

					$new_array = array();

					if ( ! empty( $categories ) ) {

						$product_args = array(
							'numberposts' => -1,
							'post_status' => array( 'publish' ),
							'post_type'   => array( 'product' ), // skip types
						);

						$product_args['tax_query'] = array(
							array(
								'taxonomy' => 'product_cat',
								'field'    => 'id',
								'terms'    => $categories,
								'operator' => 'IN',
							),
						);

						$products_ids = get_posts( $product_args );

						foreach ( $products_ids as $proid ) {
							$pri_pros[] = $proid->ID;
						}
					}

					$new_array = array_unique( array_merge( $products, $pri_pros ) );

					$rule->ProductsSession = $new_array;
					$all_new_rules_new[]   = $rule;

				}

				if ( ! empty( $all_new_rules_new ) ) {

					$_SESSION['allfetchedrules'] = $all_new_rules_new;
				} else {
					$_SESSION['allfetchedrules'] = '';
				}
			}

		}


		public function csp_front_scripts() {

			wp_enqueue_style( 'addify_csp_front_css', plugins_url( '/assets/css/addify_csp_front_css.css', __FILE__ ), false, '1.0' );
			wp_enqueue_script( 'af_csp_front_js', plugins_url( 'assets/js/addify_csp_front_js.js', __FILE__ ), array( 'jquery' ), '1.0' );

		}

		public function af_wc_price_to_display( $product, $replace = 'no' ) {

			if ( 'variable' == $product->get_type() ) {

				$variations              = $product->get_children();
				$product_variation_level = false;

				foreach ( $variations as $variation_id ) {
					$product_variation = wc_get_product( $variation_id );
					if ( is_user_logged_in() ) {

						$user = wp_get_current_user();

						$cus_base_price = get_post_meta( $product_variation->get_id(), '_cus_base_price', true );

						if ( empty( $cus_base_price ) ) {
							$cus_base_price = array();
						}

						foreach ( $cus_base_price as $rule_cus_price ) {

							if ( $user->ID == $rule_cus_price['customer_name'] ) {
								$product_variation_level = true;
								break;
							}
						}
						if ( $product_variation_level ) {
							break;
						}

						// get role base price
						foreach ( $user->roles as $value ) {

							$role_base_price = get_post_meta( $product_variation->get_id(), '_role_base_price_' . $value, true );

							$afrbp_prices = unserialize( $role_base_price );

							if ( empty( $afrbp_prices['discount_value'] ) || empty( $afrbp_prices['discount_type'] ) ) {
								continue;
							} else {
								$product_variation_level = true;
								break;
							}
						}
						if ( $product_variation_level ) {
							break;
						}
					} else {

						$role_base_price_guest = get_post_meta( $product_variation->get_id(), '_role_base_price_guest', true );
						$afrbp_prices_guest    = unserialize( $role_base_price_guest );

						if ( ! ( empty( $afrbp_prices_guest['discount_value'] ) || empty( $afrbp_prices_guest['discount_type'] ) ) ) {
							$product_variation_level = true;
						}
					}
				}//end foreach

				$min_price = 999999999999999999999999999999;
				$max_price = 0;

				$variations = $product->get_children();
				foreach ( $variations as $variation_id ) {
					$variation = wc_get_product( $variation_id );
					$price     = floatval( $variation->get_price() );
					if ( 0 != $price ) {
						if ( $price > $max_price ) {
							$max_price = $price;
						}
						if ( $price < $min_price ) {
							$min_price = $price;
						}
					}	
				}

				if ( wc_tax_enabled() ) {

					$min_price = wc_get_price_to_display(
						$product,
						array(
							'qty'   => 1,
							'price' => $min_price,
						)
					);
					$max_price = wc_get_price_to_display(
						$product,
						array(
							'qty'   => 1,
							'price' => $max_price,
						)
					);
				}

				$price_suffix = get_option( 'woocommerce_price_display_suffix' );

				if ( $min_price == $max_price ) {

					$prices = '<ins class="highlight">' . wc_price( $min_price ) . '</ins>';

				} else {

					$prices = '<ins class="highlight">' . wc_price( $min_price ) . ' - ' . wc_price( $max_price ) . '</ins>';
				}

				if ( ! empty( $price_suffix ) ) {
					$prices .= ' <small class="woocommerce-price-suffix">' . $price_suffix . '</small>';
				}

				return $prices;

			} else {

				$pro_price = floatval( get_post_meta( $product->get_id(), '_price', true ) );
				$new_price = $product->get_price();

				$price_suffix = get_option( 'woocommerce_price_display_suffix' );

				if ( wc_tax_enabled() ) {

					$pro_price = wc_get_price_to_display(
						$product,
						array(
							'qty'   => 1,
							'price' => $pro_price,
						)
					);
					$new_price = wc_get_price_to_display(
						$product,
						array(
							'qty'   => 1,
							'price' => $new_price,
						)
					);
				}

				if ( 'yes' !== $replace ) {
					if ( $new_price < $pro_price ) {
						$prices = '<del class="strike">' . wc_price( $pro_price ) . '</del><ins class="highlight">' . wc_price( $new_price ) . '</ins>';
					} else {
						$prices = '<ins class="highlight">' . wc_price( $new_price ) . '</ins>';
					}
					

				} else {

					$prices = '<ins class="highlight">' . wc_price( $new_price ) . '</ins>';
				}

				if ( ! empty( $price_suffix ) ) {

					$prices .= ' <small class="woocommerce-price-suffix">' . $price_suffix . '</small>';

				}

				return $prices;
			}
		}


		public function af_csp_custom_price_html( $price, $product ) {

			$prices = $price;

			// Hide Price Feature Start
			$user                             = wp_get_current_user();
			$customer_discount                = false;
			$enable_hide_price_feature        = get_option( 'csp_enable_hide_pirce' );
			$enable_for_guest                 = get_option( 'csp_enable_hide_pirce_guest' );
			$csp_enable_hide_pirce_registered = get_option( 'csp_enable_hide_pirce_registered' );
			$csp_hide_user_role               = unserialize( get_option( 'csp_hide_user_role' ) );
			$enable_hide_price                = get_option( 'csp_hide_price' );
			$cps_price_text                   = get_option( 'csp_price_text' );

			if ( ! empty( $enable_hide_price_feature ) && 'yes' == $enable_hide_price_feature ) {

				$csp_hide_products   = unserialize( get_option( 'csp_hide_products' ) );
				$cps_hide_categories = unserialize( get_option( 'cps_hide_categories' ) );

				// For Guest Users
				if ( ! empty( $enable_for_guest ) && 'yes' == $enable_for_guest ) {
					if ( ! is_user_logged_in() ) {
						if ( ! empty( $csp_hide_products ) ) {
							if ( in_array( $product->get_id(), (array) $csp_hide_products ) ) {

								if ( ! empty( $enable_hide_price ) && 'yes' == $enable_hide_price ) {
									?>
									<style>
										.woocommerce-variation-price{ display: none !important;}
									</style>
									<?php
									return $cps_price_text;
								}
							}
						}

						if ( ! empty( $cps_hide_categories ) ) {
							foreach ( $cps_hide_categories as $cat ) {
								if ( has_term( $cat, 'product_cat', $product->get_id() ) ) {
									?>
									<style>
										.woocommerce-variation-price{ display: none !important;}
									</style>
									<?php
									return $cps_price_text;
								}
							}
						}
					}
				}

				// For Registered Users
				if ( ! empty( $csp_enable_hide_pirce_registered ) && 'yes' == $csp_enable_hide_pirce_registered ) {

					if ( is_user_logged_in() ) {

						// get Current User Role
						$curr_user      = wp_get_current_user();
						$user_data      = get_user_meta( $curr_user->ID );
						$curr_user_role = $curr_user->roles[0];

						if ( in_array( $curr_user_role, $csp_hide_user_role ) ) {

							if ( in_array( $product->get_id(), (array) $csp_hide_products ) ) {

								if ( ! empty( $enable_hide_price ) && 'yes' == $enable_hide_price ) {

									?>
									<style>
										.woocommerce-variation-price{ display: none !important;}
									</style>
									<?php
									return $cps_price_text;
								}
							} 
							if ( ! empty( $cps_hide_categories ) && ! empty( $enable_hide_price ) && 'yes' == $enable_hide_price ) {

								foreach ( $cps_hide_categories as $cat ) {
									if ( has_term( $cat, 'product_cat', $product->get_id() ) ) {
										?>
										<style>
											.woocommerce-variation-price{ display: none !important;}
										</style>
										<?php
										return $cps_price_text;
									}
								}
							}
						}
					}
				}
			}

			// Hide Price Feature End

			$user = wp_get_current_user();

			if ( is_user_logged_in() ) {

				// get customer specifc price
				$cus_base_price = get_post_meta( $product->get_id(), '_cus_base_price', true );

				// get role base price
				foreach ( $user->roles as $value ) {

					$role_base_price = get_post_meta( $product->get_id(), '_role_base_price_' . $value, true );

					$afrbp_prices = unserialize( $role_base_price );

					if ( empty( $afrbp_prices['discount_value'] ) || empty( $afrbp_prices['discount_type'] ) ) {
						continue;
					} else {
						break;
					}
				}

				if ( ! empty( $cus_base_price ) ) {

					foreach ( $cus_base_price as $cus_price ) {

						if ( $user->ID == $cus_price['customer_name'] ) {

							if ( '' != $cus_price['discount_value'] || 0 != $cus_price['discount_value'] ) {

								if ( ! isset( $cus_price['replace_orignal_price'] ) ) {
									$cus_price['replace_orignal_price'] = 'no';
								}

								return $this->af_wc_price_to_display( $product, $cus_price['replace_orignal_price'] );

							} else {

								$prices = $price;
							}
						}
					}
				} else {

					$prices = $price;
				}

				// Role Based Pricing
				// chcek if there is customer specific pricing then role base pricing will not work.
				if ( !empty( $afrbp_prices )  ) {

					// Product Price
					if ( isset( $afrbp_prices['discount_value'] )  && ( '' != $afrbp_prices['discount_value'] || 0 != $afrbp_prices['discount_value'] ) ) {

						if ( ! isset( $afrbp_prices['replace_orignal_price'] ) ) {
							$afrbp_prices['replace_orignal_price'] = 'no';
						}

						return $this->af_wc_price_to_display( $product, $afrbp_prices['replace_orignal_price'] );
					}
				}

				// Rules
				if ( true ) {

					if ( empty( $_SESSION['allfetchedrules'] ) ) {

						echo '';

					} else {

						$all_rules = $_SESSION['allfetchedrules'];

					}

					if ( ! empty( $all_rules ) ) {
						foreach ( $all_rules as $rule ) {

							$istrue = false;

							$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

							if ( 'yes' == $applied_on_all_products ) {
								$istrue = true;
							} elseif ( ! empty( $rule->ProductsSession ) && ( in_array( $product->get_id(), $rule->ProductsSession ) || in_array( $product->get_parent_id(), $rule->ProductsSession ) ) ) {
								$istrue = true;
							}

							if ( $istrue ) {

								// get Rule customer specifc price
								$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

								// get role base price
								foreach ( $user->roles as $value ) {

									$rule_role_base_price = get_post_meta( $rule->ID, 'rrole_base_price_' . $value, true );
									$rule_afrbp_prices    = unserialize( $rule_role_base_price );

									if ( empty( $rule_afrbp_prices['discount_value'] ) || empty( $rule_afrbp_prices['discount_type'] ) ) {
										continue;
									} else {

										break;
									}
								}

								$customer_discount = false;

								if ( ! empty( $rule_cus_base_price ) ) {
									foreach ( $rule_cus_base_price as $rule_cus_price ) {

										if ( $user->ID == $rule_cus_price['customer_name'] ) {

											if ( '' != $rule_cus_price['discount_value'] || 0 != $rule_cus_price['discount_value'] ) {

												if ( ! isset( $rule_cus_price['replace_orignal_price'] ) ) {
													$rule_cus_price['replace_orignal_price'] = 'no';
												}

												return $this->af_wc_price_to_display( $product, $rule_cus_price['replace_orignal_price'] );

											} else {

												$prices = $price;
											}
										}
									}
								} else {

									$prices = $price;
								}

								// Role Based Pricing
								// chcek if there is customer specific pricing then role base pricing will not work.
								if ( true ) {

									// Product Price
									if ( '' != $rule_afrbp_prices['discount_value'] || 0 != $rule_afrbp_prices['discount_value'] ) {

										if ( ! isset( $rule_afrbp_prices['replace_orignal_price'] ) ) {
											$rule_afrbp_prices['replace_orignal_price'] = 'no';
										}

										return $this->af_wc_price_to_display( $product, $rule_afrbp_prices['replace_orignal_price'] );

									} else {

										$prices = $price;
									}
								}
							}
						}
					}
				}
			} elseif ( ! is_user_logged_in() ) {

				// Role Based Pricing for Non Loggedin
				// chcek if there is customer specific pricing then role base pricing will not work.
				if ( true ) {

					// get role base price
					$role_base_price_guest = get_post_meta( $product->get_id(), '_role_base_price_guest', true );
					$afrbp_prices_guest    = unserialize( $role_base_price_guest );

					// Product Price
					if ( !is_bool( $afrbp_prices_guest ) && ( '' != $afrbp_prices_guest['discount_value'] || 0 != $afrbp_prices_guest['discount_value'] ) ) {

						if ( ! isset( $afrbp_prices_guest['replace_orignal_price'] ) ) {
							$afrbp_prices_guest['replace_orignal_price'] = 'no';
						}

						return $this->af_wc_price_to_display( $product, $afrbp_prices_guest['replace_orignal_price'] );

					} else {

						$prices = $price;
					}
				} else {

					$prices = $price;
				}

				// Rules - guest users
				if ( true ) {

					if ( empty( $_SESSION['allfetchedrules'] ) ) {

						echo '';

					} else {

						$all_rules = $_SESSION['allfetchedrules'];

					}

					if ( ! empty( $all_rules ) ) {
						foreach ( $all_rules as $rule ) {

							$istrue = false;

							$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

							if ( 'yes' == $applied_on_all_products ) {
								$istrue = true;
							} elseif ( ! empty( $rule->ProductsSession ) && ( in_array( $product->get_id(), $rule->ProductsSession ) || in_array( $product->get_parent_id(), $rule->ProductsSession ) ) ) {
								$istrue = true;
							}

							if ( $istrue ) {

								// get Rule customer specifc price
								$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

								// get role base price
								$rule_role_base_price_guest = get_post_meta( $rule->ID, 'rrole_base_price_guest', true );
								$rule_afrbp_prices_guest    = unserialize( $rule_role_base_price_guest );

								// Role Based Pricing
								// chcek if there is customer specific pricing then role base pricing will not work.
								if ( true ) {

									// Product Price
									if ( '' != $rule_afrbp_prices_guest['discount_value'] || 0 != $rule_afrbp_prices_guest['discount_value'] ) {

										if ( ! isset( $rule_afrbp_prices_guest['replace_orignal_price'] ) ) {
											$rule_afrbp_prices_guest['replace_orignal_price'] = 'no';
										}

										return $this->af_wc_price_to_display( $product, $rule_afrbp_prices_guest['replace_orignal_price'] );

									} else {

										$prices = $price;

									}
								}
							}
						}
					}
				}
			}

			return $prices;
		}

		public function af_csp_price_adjustment( $price, $product ) {

			$new_price = $this->af_csp_custom_price( $price, $product );

			if ( is_array( $new_price ) ) {

				return floatval( $new_price[0] );
			}

			if ( wc_tax_enabled() ) {
				if ( 'yes' === get_option( 'woocommerce_prices_include_tax' ) && 'yes' === get_option( 'csp_apply_disc_excl_tax' ) ) {

					$tax_rates = WC_Tax::get_rates( $product->get_tax_class() );
					$taxes     = WC_Tax::calc_tax( $new_price, $tax_rates, false );

					if ( 'yes' === get_option( 'woocommerce_tax_round_at_subtotal' ) ) {
						$taxes_total = array_sum( $taxes );
					} else {
						$taxes_total = array_sum( array_map( 'wc_round_tax_total', $taxes ) );
					}

					$return_price = round( $new_price + $taxes_total, wc_get_price_decimals() );

					return $return_price;
				}
			}

			return $new_price;
		}

		public function af_csp_custom_price( $price, $product ) {

			$prices            = $price;
			$customer_discount = false;
			$pro_price         = floatval( get_post_meta( $product->get_id(), '_price', true ) );

			if ( wc_tax_enabled() ) {
				if ( 'yes' === get_option( 'woocommerce_prices_include_tax' ) && 'yes' === get_option( 'csp_apply_disc_excl_tax' ) ) {
					$pro_price = wc_get_price_excluding_tax( $product , array( 'qty' => 1 , 'price' => $pro_price ) );
				}
			}

			$user = wp_get_current_user();

			if ( is_user_logged_in() ) {

				// get customer specific price
				$cus_base_price = get_post_meta( $product->get_id(), '_cus_base_price', true );

				// get role base price
				foreach ( $user->roles as $value ) {

					$role_base_price = get_post_meta( $product->get_id(), '_role_base_price_' . $value, true );

					$afrbp_prices = unserialize( $role_base_price );

					if ( empty( $afrbp_prices['discount_value'] ) || empty( $afrbp_prices['discount_type'] ) ) {
						continue;
					} else {
						break;
					}
				}
				// $role_base_price = get_post_meta($product->get_id(), '_role_base_price_' . $user->roles[0], true);

				if ( ! empty( $cus_base_price ) ) {
					foreach ( $cus_base_price as $cus_price ) {

						if ( $user->ID == $cus_price['customer_name'] ) {

							if ( '' != $cus_price['discount_value'] || 0 != $cus_price['discount_value'] ) {

								if ( 'fixed_price' == $cus_price['discount_type'] ) {
									$prices = $cus_price['discount_value'];
									return array( $prices, 'fixed');
								} elseif ( 'fixed_increase' == $cus_price['discount_type'] ) {

									$newprice = $pro_price + $cus_price['discount_value'];

									$prices = $newprice;
									return $prices;
								} elseif ( 'fixed_decrease' == $cus_price['discount_type'] ) {

									$newprice = $pro_price - $cus_price['discount_value'];

									$prices = $newprice;
									return $prices;

								} elseif ( 'percentage_decrease' == $cus_price['discount_type'] ) {

									$percent_price = $pro_price * $cus_price['discount_value'] / 100;

									$newprice = $pro_price - $percent_price;

									$prices = $newprice;
									return $prices;

								} elseif ( 'percentage_increase' == $cus_price['discount_type'] ) {

									$percent_price = $pro_price * $cus_price['discount_value'] / 100;

									$newprice = $pro_price + $percent_price;

									$prices = $newprice;
									return $prices;

								} else {

									$prices = $cus_price['discount_value'];
								}
							} else {

								$prices = $price;
							}
						}
					}
				} else {

					$prices = $price;
				}

				// Role Based Pricing
				// chcek if there is customer specific pricing then role base pricing will not work.
				if ( ! is_bool( $afrbp_prices ) ) {

					// Product Price
					
					if ( '' != $afrbp_prices['discount_value'] || 0 != $afrbp_prices['discount_value'] ) {

						if ( 'fixed_price' == $afrbp_prices['discount_type'] ) {
							$prices = $afrbp_prices['discount_value'];
							return array( $prices, 'fixed');
						} elseif ( 'fixed_increase' == $afrbp_prices['discount_type'] ) {

							$newprice = $pro_price + $afrbp_prices['discount_value'];

							$prices = $newprice;
							return $prices;
						} elseif ( 'fixed_decrease' == $afrbp_prices['discount_type'] ) {

							$newprice = $pro_price - $afrbp_prices['discount_value'];

							$prices = $newprice;
							return $prices;

						} elseif ( 'percentage_decrease' == $afrbp_prices['discount_type'] ) {

							$percent_price = $pro_price * $afrbp_prices['discount_value'] / 100;

							$newprice = $pro_price - $percent_price;

							$prices = $newprice;
							return $prices;

						} elseif ( 'percentage_increase' == $afrbp_prices['discount_type'] ) {

							$percent_price = $pro_price * $afrbp_prices['discount_value'] / 100;

							$newprice = $pro_price + $percent_price;

							$prices = $newprice;
							return $prices;

						} else {

							$prices = $afrbp_prices['discount_value'];
						}
					} else {

						$prices = $price;
					}
				}

				// Rules
				if ( true ) {

					if ( empty( $_SESSION['allfetchedrules'] ) ) {

						echo '';

					} else {

						$all_rules = $_SESSION['allfetchedrules'];
					}

					if ( ! empty( $all_rules ) ) {
						foreach ( $all_rules as $rule ) {

							$istrue = false;

							$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

							if ( 'yes' == $applied_on_all_products ) {
								$istrue = true;
							} elseif ( ! empty( $rule->ProductsSession ) && ( in_array( $product->get_id(), $rule->ProductsSession ) || in_array( $product->get_parent_id(), $rule->ProductsSession ) ) ) {
								$istrue = true;
							}

							if ( $istrue ) {

								// get Rule customer specifc price
								$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

								// get role base price
								foreach ( $user->roles as $value ) {

									$rule_role_base_price = get_post_meta( $rule->ID, 'rrole_base_price_' . $value, true );
									$rule_afrbp_prices    = unserialize( $rule_role_base_price );

									if ( empty( $rule_afrbp_prices['discount_value'] ) || empty( $rule_afrbp_prices['discount_type'] ) ) {
										continue;
									} else {
										break;
									}
								}

								$customer_discount = false;

								if ( ! empty( $rule_cus_base_price ) ) {
									foreach ( $rule_cus_base_price as $rule_cus_price ) {

										if ( $user->ID == $rule_cus_price['customer_name'] ) {

											if ( '' != $rule_cus_price['discount_value'] || 0 != $rule_cus_price['discount_value'] ) {

												if ( 'fixed_price' == $rule_cus_price['discount_type'] ) {
													$prices = $rule_cus_price['discount_value'];
													return array( $prices, 'fixed');
												} elseif ( 'fixed_increase' == $rule_cus_price['discount_type'] ) {

													$newprice = $pro_price + $rule_cus_price['discount_value'];

													$prices = $newprice;
													return $prices;
												} elseif ( 'fixed_decrease' == $rule_cus_price['discount_type'] ) {

													$newprice = $pro_price - $rule_cus_price['discount_value'];

													$prices = $newprice;
													return $prices;

												} elseif ( 'percentage_decrease' == $rule_cus_price['discount_type'] ) {

													$percent_price = $pro_price * $rule_cus_price['discount_value'] / 100;

													$newprice = $pro_price - $percent_price;

													$prices = $newprice;
													return $prices;

												} elseif ( 'percentage_increase' == $rule_cus_price['discount_type'] ) {

													$percent_price = $pro_price * $rule_cus_price['discount_value'] / 100;

													$newprice = $pro_price + $percent_price;

													$prices = $newprice;
													return $prices;

												} else {

													$prices = $rule_cus_price['discount_value'];
												}
											} else {

												$prices = $price;
											}
										}
									}
								} else {

									$prices = $price;
								}

								// Role Based Pricing
								// chcek if there is customer specific pricing then role base pricing will not work.
								if ( true && !empty($rule_afrbp_prices)) {

									// Product Price
									if ( '' != $rule_afrbp_prices['discount_value'] || 0 != $rule_afrbp_prices['discount_value'] ) {

										if ( 'fixed_price' == $rule_afrbp_prices['discount_type'] ) {
											$prices = $rule_afrbp_prices['discount_value'];
											return array( $prices, 'fixed');
										} elseif ( 'fixed_increase' == $rule_afrbp_prices['discount_type'] ) {

											$newprice = $pro_price + $rule_afrbp_prices['discount_value'];

											$prices = $newprice;
											return $prices;
										} elseif ( 'fixed_decrease' == $rule_afrbp_prices['discount_type'] ) {

											$newprice = $pro_price - $rule_afrbp_prices['discount_value'];

											$prices = $newprice;
											return $prices;

										} elseif ( 'percentage_decrease' == $rule_afrbp_prices['discount_type'] ) {

											$percent_price = $pro_price * $rule_afrbp_prices['discount_value'] / 100;

											$newprice = $pro_price - $percent_price;

											$prices = $newprice;
											return $prices;

										} elseif ( 'percentage_increase' == $rule_afrbp_prices['discount_type'] ) {

											$percent_price = $pro_price * $rule_afrbp_prices['discount_value'] / 100;

											$newprice = $pro_price + $percent_price;

											$prices = $newprice;
											return $prices;

										} else {

											$prices = $rule_afrbp_prices['discount_value'];
										}
									} else {

										$prices = $price;
									}
								}
							}
						}
					}
				}
			} elseif ( ! is_user_logged_in() ) {

				// Role Based Pricing for guest
				// chcek if there is customer specific pricing then role base pricing will not work.
				if ( true && !empty($rule_role_base_price_guest)) {

					// get role base price
					$rule_role_base_price_guest = get_post_meta( $product->get_id(), '_role_base_price_guest', true );
					$rule_afrbp_prices_guest    = unserialize( $rule_role_base_price_guest );

					// Product Price
					if ( !is_bool($rule_afrbp_prices_guest) && ( '' != $rule_afrbp_prices_guest['discount_value'] || 0 != $rule_afrbp_prices_guest['discount_value'] ) ) {

						if ( 'fixed_price' == $rule_afrbp_prices_guest['discount_type'] ) {
							$prices = $rule_afrbp_prices_guest['discount_value'];
							return array( $prices, 'fixed');
						} elseif ( 'fixed_increase' == $rule_afrbp_prices_guest['discount_type'] ) {

							$newprice = $pro_price + $rule_afrbp_prices_guest['discount_value'];

							$prices = $newprice;
							return $prices;
						} elseif ( 'fixed_decrease' == $rule_afrbp_prices_guest['discount_type'] ) {

							$newprice = $pro_price - $rule_afrbp_prices_guest['discount_value'];

							$prices = $newprice;
							return $prices;

						} elseif ( 'percentage_decrease' == $rule_afrbp_prices_guest['discount_type'] ) {

							$percent_price = $pro_price * $rule_afrbp_prices_guest['discount_value'] / 100;

							$newprice = $pro_price - $percent_price;

							$prices = $newprice;
							return $prices;

						} elseif ( 'percentage_increase' == $rule_afrbp_prices_guest['discount_type'] ) {

							$percent_price = $pro_price * $rule_afrbp_prices_guest['discount_value'] / 100;

							$newprice = $pro_price + $percent_price;

							$prices = $newprice;
							return $prices;

						} else {

							$prices = $rule_afrbp_prices_guest['discount_value'];
						}
					} else {

						$prices = $price;
					}
				} else {

					$prices = $price;
				}

				// Rules - guest users
				if ( true ) {

					if ( empty( $_SESSION['allfetchedrules'] ) ) {

						echo '';

					} else {

						$all_rules = $_SESSION['allfetchedrules'];

					}

					if ( ! empty( $all_rules ) ) {
						foreach ( $all_rules as $rule ) {

							$istrue = false;

							$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

							if ( 'yes' == $applied_on_all_products ) {
								$istrue = true;
							} elseif ( ! empty( $rule->ProductsSession ) && ( in_array( $product->get_id(), $rule->ProductsSession ) || in_array( $product->get_parent_id(), $rule->ProductsSession ) ) ) {
								$istrue = true;
							}

							if ( $istrue ) {

								// get Rule customer specifc price
								$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

								// get role base price
								$rule_role_base_price_guest = get_post_meta( $rule->ID, 'rrole_base_price_guest', true );
								$rule_afrbp_prices_guest    = unserialize( $rule_role_base_price_guest );

								// Role Based Pricing
								// chcek if there is customer specific pricing then role base pricing will not work.
								if ( true ) {

									// Product Price
									if ( '' != $rule_afrbp_prices_guest['discount_value'] || 0 != $rule_afrbp_prices_guest['discount_value'] ) {

										if ( 'fixed_price' == $rule_afrbp_prices_guest['discount_type'] ) {
											$prices = $rule_afrbp_prices_guest['discount_value'];
											return array( $prices, 'fixed');
										} elseif ( 'fixed_increase' == $rule_afrbp_prices_guest['discount_type'] ) {

											$newprice = $pro_price + $rule_afrbp_prices_guest['discount_value'];

											$prices = $newprice;
											return $prices;
										} elseif ( 'fixed_decrease' == $rule_afrbp_prices_guest['discount_type'] ) {

											$newprice = $pro_price - $rule_afrbp_prices_guest['discount_value'];

											$prices = $newprice;
											return $prices;

										} elseif ( 'percentage_decrease' == $rule_afrbp_prices_guest['discount_type'] ) {

											$percent_price = $pro_price * $rule_afrbp_prices_guest['discount_value'] / 100;

											$newprice = $pro_price - $percent_price;

											$prices = $newprice;
											return $prices;

										} elseif ( 'percentage_increase' == $rule_afrbp_prices_guest['discount_type'] ) {

											$percent_price = $pro_price * $rule_afrbp_prices_guest['discount_value'] / 100;

											$newprice = (float) $pro_price + (float) $percent_price;

											$prices = $newprice;
											return $prices;

										} else {

											$prices = $rule_afrbp_prices_guest['discount_value'];
										}
									} else {

										$prices = $price;
									}
								} else {

									$prices = $price;

								}
							}
						}
					}
				}
			}

			return $pro_price;
		}

		public function add_user_id_to_woocommerce_get_variation_prices_hash( $hash ) {
			$hash[] = get_current_user_id();
			return $hash;
		}


		public function af_csp_custom_price_variation_product_level( $price, $product ) {

			wc_delete_product_transients( $product->get_id() );

			$prices = $price;

			$pro_price = floatval( get_post_meta( $product->get_id(), '_price', true ) );

			$user = wp_get_current_user();

			if ( is_user_logged_in() ) {

				// get customer specifc price
				$cus_base_price = get_post_meta( $product->get_id(), '_cus_base_price', true );

				// get role base price
				foreach ( $user->roles as $value ) {

					$role_base_price = get_post_meta( $product->get_id(), '_role_base_price_' . $value, true );

					$afrbp_prices = unserialize( $role_base_price );

					if ( empty( $afrbp_prices['discount_value'] ) || empty( $afrbp_prices['discount_type'] ) ) {
						continue;
					} else {
						break;
					}
				}

				if ( ! empty( $cus_base_price ) ) {
					foreach ( $cus_base_price as $cus_price ) {

						if ( $user->ID == $cus_price['customer_name'] ) {

							if ( '' != $cus_price['discount_value'] || 0 != $cus_price['discount_value'] ) {

								if ( 'fixed_price' == $cus_price['discount_type'] ) {
									$prices = $cus_price['discount_value'];
									return $prices;
								} elseif ( 'fixed_increase' == $cus_price['discount_type'] ) {

									$newprice = $pro_price + $cus_price['discount_value'];

									$prices = $newprice;
								} elseif ( 'fixed_decrease' == $cus_price['discount_type'] ) {

									$newprice = $pro_price - $cus_price['discount_value'];

									$prices = $newprice;
									return $prices;
								} elseif ( 'percentage_decrease' == $cus_price['discount_type'] ) {

									$percent_price = $pro_price * $cus_price['discount_value'] / 100;

									$newprice = $pro_price - $percent_price;

									$prices = $newprice;
									return $prices;
								} elseif ( 'percentage_increase' == $cus_price['discount_type'] ) {

									$percent_price = $pro_price * $cus_price['discount_value'] / 100;

									$newprice = $pro_price + $percent_price;

									$prices = $newprice;
									return $prices;

								} else {

									$prices = $cus_price['discount_value'];
									return $prices;
								}
							} else {

								$prices = $price;
							}
						}
					}
				} else {

					$prices = $price;
				}

				// Role Based Pricing
				// chcek if there is customer specific pricing then role base pricing will not work.
				if ( !is_bool( $afrbp_prices ) ) {

					// Product Price
					if ( '' != $afrbp_prices['discount_value'] || 0 != $afrbp_prices['discount_value'] ) {

						if ( 'fixed_price' == $afrbp_prices['discount_type'] ) {
							$prices = $afrbp_prices['discount_value'];
							return $prices;
						} elseif ( 'fixed_increase' == $afrbp_prices['discount_type'] ) {

							$newprice = $pro_price + $afrbp_prices['discount_value'];

							$prices = $newprice;
							return $prices;
						} elseif ( 'fixed_decrease' == $afrbp_prices['discount_type'] ) {

							$newprice = $pro_price - $afrbp_prices['discount_value'];

							$prices = $newprice;
							return $prices;

						} elseif ( 'percentage_decrease' == $afrbp_prices['discount_type'] ) {

							$percent_price = $pro_price * $afrbp_prices['discount_value'] / 100;

							$newprice = $pro_price - $percent_price;

							$prices = $newprice;
							return $prices;

						} elseif ( 'percentage_increase' == $afrbp_prices['discount_type'] ) {

							$percent_price = $pro_price * $afrbp_prices['discount_value'] / 100;

							$newprice = $pro_price + $percent_price;

							$prices = $newprice;
							return $prices;

						} else {

							$prices = $afrbp_prices['discount_value'];
						}
					} else {

						$prices = $price;
					}
				}
			} elseif ( ! is_user_logged_in() ) {

				// Role Based Pricing for guest
				// chcek if there is customer specific pricing then role base pricing will not work.
				if ( true ) {

					// get role base price
					$rule_role_base_price_guest = get_post_meta( $product->get_id(), '_role_base_price_guest', true );
					$rule_afrbp_prices_guest    = unserialize( $rule_role_base_price_guest );

					// Product Price
					if ( !is_bool( $rule_afrbp_prices_guest ) &&  ( '' != $rule_afrbp_prices_guest['discount_value'] || 0 != $rule_afrbp_prices_guest['discount_value'] ) ) {

						if ( 'fixed_price' == $rule_afrbp_prices_guest['discount_type'] ) {
							$prices = $rule_afrbp_prices_guest['discount_value'];
						} elseif ( 'fixed_increase' == $rule_afrbp_prices_guest['discount_type'] ) {

							$newprice = $pro_price + $rule_afrbp_prices_guest['discount_value'];

							$prices = $newprice;
							return $prices;
						} elseif ( 'fixed_decrease' == $rule_afrbp_prices_guest['discount_type'] ) {

							$newprice = $pro_price - $rule_afrbp_prices_guest['discount_value'];

							$prices = $newprice;
							return $prices;

						} elseif ( 'percentage_decrease' == $rule_afrbp_prices_guest['discount_type'] ) {

							$percent_price = $pro_price * $rule_afrbp_prices_guest['discount_value'] / 100;

							$newprice = $pro_price - $percent_price;

							$prices = $newprice;

							return $prices;
						} elseif ( 'percentage_increase' == $rule_afrbp_prices_guest['discount_type'] ) {

							$percent_price = $pro_price * $rule_afrbp_prices_guest['discount_value'] / 100;

							$newprice = $pro_price + $percent_price;

							$prices = $newprice;
							return $prices;

						} else {

							$prices = $rule_afrbp_prices_guest['discount_value'];
							return $prices;
						}
					} else {

						$prices = $price;
					}
				} else {

					$prices = $price;
				}
			}

			return $prices;
		}


		// true, $product_id, $quantity, $variation_id, $variations

		public function csp_validate_min_max_qty( $csppdata, $product_id, $qty, $variation_id = 0 ) {

			$user = wp_get_current_user();

			$prod = wc_get_product( $variation_id );

			if ( is_user_logged_in() ) {

				if ( 0 == $variation_id ) {
					// Simple Product

					$targeted_id = $product_id;

					foreach ( WC()->cart->get_cart() as $cart_item ) {
						if ( $cart_item['product_id'] == $targeted_id ) {
							$oqty = $cart_item['quantity'];
							break; // stop the loop if product is found
						}
					}
					// Displaying the quantity if targeted product is in cart
					if ( ! empty( $oqty ) ) {

						$old_qty = $oqty;
					} else {
						$old_qty = 0;
					}

					// get customer specifc price
					$cus_base_price = get_post_meta( $product_id, '_cus_base_price', true );

					// get role base price
					foreach ( $user->roles as $value ) {

						$role_base_price = get_post_meta( $product_id, '_role_base_price_' . $value, true );

						$afrbp_prices = unserialize( $role_base_price );

						if ( empty( $afrbp_prices['discount_value'] ) || empty( $afrbp_prices['discount_type'] ) ) {
							continue;
						} else {
							break;
						}
					}

					if ( ! empty( $cus_base_price ) ) {
						foreach ( $cus_base_price as $cus_price ) {

							if ( $user->ID == $cus_price['customer_name'] ) {

								if ( '' != $cus_price['discount_value'] || 0 != $cus_price['discount_value'] ) {

									if ( '' != $cus_price['min_qty'] || 0 != $cus_price['min_qty'] ) {
										$min_qty = intval( $cus_price['min_qty'] );
									} else {
										$min_qty = '';
									}

									if ( '' != $cus_price['max_qty'] || 0 != $cus_price['max_qty'] ) {
										$max_qty = intval( $cus_price['max_qty'] );
									} else {
										$max_qty = '';
									}

									if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
										$csppdata      = false;
										$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
										$this->csp_wc_add_notice( $error_message );
										return $csppdata;

									} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

										$csppdata      = false;
										$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
										$this->csp_wc_add_notice( $error_message );
										return $csppdata;

									} else {
										return true;
									}
								}
							}
						}
					}

					// Role Based Pricing
					// chcek if there is customer specific pricing then role base pricing will not work.
					if ( true && !empty($afrbp_prices) ) {

						// Product Price
						if ( '' != $afrbp_prices['discount_value'] || 0 != $afrbp_prices['discount_value'] ) {

							if ( '' != $afrbp_prices['min_qty'] || 0 != $afrbp_prices['min_qty'] ) {
								$min_qty = intval( $afrbp_prices['min_qty'] );
							} else {
								$min_qty = '';
							}

							if ( '' != $afrbp_prices['max_qty'] || 0 != $afrbp_prices['max_qty'] ) {
								$max_qty = intval( $afrbp_prices['max_qty'] );
							} else {
								$max_qty = '';
							}

							if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
								$csppdata      = false;
								$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
								$this->csp_wc_add_notice( $error_message );
								return $csppdata;

							} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

								$csppdata      = false;
								$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
								$this->csp_wc_add_notice( $error_message );
								return $csppdata;

							} else {
								return true;
							}
						}
					}

					// Rules
					if ( true ) {

						if ( empty( $_SESSION['allfetchedrules'] ) ) {

							echo '';

						} else {

							$all_rules = $_SESSION['allfetchedrules'];

						}

						if ( ! empty( $all_rules ) ) {
							foreach ( $all_rules as $rule ) {

								$istrue = false;

								$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

								if ( 'yes' == $applied_on_all_products ) {
									$istrue = true;
								} elseif ( ! empty( $rule->ProductsSession ) && in_array( $product_id, $rule->ProductsSession ) ) {
									$istrue = true;
								}

								if ( $istrue ) {

									// get Rule customer specifc price
									$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

									// get role base price
									foreach ( $user->roles as $value ) {

										$rule_role_base_price = get_post_meta( $rule->ID, 'rrole_base_price_' . $value, true );

										$rule_afrbp_prices = unserialize( $rule_role_base_price );

										if ( empty( $rule_afrbp_prices['discount_value'] ) || empty( $rule_afrbp_prices['discount_type'] ) ) {
											continue;
										} else {
											break;
										}
									}

									if ( ! empty( $rule_cus_base_price ) ) {
										foreach ( $rule_cus_base_price as $rule_cus_price ) {

											if ( $user->ID == $rule_cus_price['customer_name'] ) {

												if ( '' != $rule_cus_price['discount_value'] || 0 != $rule_cus_price['discount_value'] ) {

													if ( '' != $rule_cus_price['min_qty'] || 0 != $rule_cus_price['min_qty'] ) {
														$min_qty = intval( $rule_cus_price['min_qty'] );
													} else {
														$min_qty = '';
													}

													if ( '' != $rule_cus_price['max_qty'] || 0 != $rule_cus_price['max_qty'] ) {
														$max_qty = intval( $rule_cus_price['max_qty'] );
													} else {
														$max_qty = '';
													}

													if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
														$csppdata      = false;
														$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
														$this->csp_wc_add_notice( $error_message );
														return $csppdata;

													} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

														$csppdata      = false;
														$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
														$this->csp_wc_add_notice( $error_message );
														return $csppdata;

													} else {
														return true;
													}
												}
											}
										}
									}

									// Role Based Pricing
									// chcek if there is customer specific pricing then role base pricing will not work.
									if ( true && !empty($rule_afrbp_prices) ) {

										// Product Price
										if ( '' != $rule_afrbp_prices['discount_value'] || 0 != $rule_afrbp_prices['discount_value'] ) {

											if ( '' != $rule_afrbp_prices['min_qty'] || 0 != $rule_afrbp_prices['min_qty'] ) {
												$min_qty = intval( $rule_afrbp_prices['min_qty'] );
											} else {
												$min_qty = '';
											}

											if ( '' != $rule_afrbp_prices['max_qty'] || 0 != $rule_afrbp_prices['max_qty'] ) {
												$max_qty = intval( $rule_afrbp_prices['max_qty'] );
											} else {
												$max_qty = '';
											}

											if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
												$csppdata      = false;
												$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
												$this->csp_wc_add_notice( $error_message );
												return $csppdata;

											} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

												$csppdata      = false;
												$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
												$this->csp_wc_add_notice( $error_message );
												return $csppdata;

											} else {
												return true;
											}
										}
									}
								}
							}
						}
					}
				} else {

					// Variable Product

					$targeted_id = $variation_id;

					foreach ( WC()->cart->get_cart() as $cart_item ) {
						if ( $cart_item['variation_id'] == $targeted_id ) {
							$oqty = $cart_item['quantity'];
							break; // stop the loop if product is found
						}
					}
					// Displaying the quantity if targeted product is in cart
					if ( ! empty( $oqty ) ) {

						$old_qty = $oqty;
					} else {
						$old_qty = 0;
					}

					// get customer specifc price
					$cus_base_price = get_post_meta( $variation_id, '_cus_base_price', true );

					// get role base price
					foreach ( $user->roles as $value ) {

						$role_base_price = get_post_meta( $variation_id, '_role_base_price_' . $value, true );

						$afrbp_prices = unserialize( $role_base_price );

						if ( empty( $afrbp_prices['discount_value'] ) || empty( $afrbp_prices['discount_type'] ) ) {
							continue;
						} else {
							break;
						}
					}

					if ( ! empty( $cus_base_price ) ) {
						foreach ( $cus_base_price as $cus_price ) {

							if ( $user->ID == $cus_price['customer_name'] ) {

								if ( '' != $cus_price['discount_value'] || 0 != $cus_price['discount_value'] ) {

									if ( '' != $cus_price['min_qty'] || 0 != $cus_price['min_qty'] ) {
										$min_qty = intval( $cus_price['min_qty'] );
									} else {
										$min_qty = '';
									}

									if ( '' != $cus_price['max_qty'] || 0 != $cus_price['max_qty'] ) {
										$max_qty = intval( $cus_price['max_qty'] );
									} else {
										$max_qty = '';
									}

									if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
										$csppdata      = false;
										$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
										$this->csp_wc_add_notice( $error_message );
										return $csppdata;

									} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

										$csppdata      = false;
										$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
										$this->csp_wc_add_notice( $error_message );
										return $csppdata;

									} else {
										return true;
									}
								}
							}
						}
					}

					// Role Based Pricing
					// chcek if there is customer specific pricing then role base pricing will not work.
					if ( true && !empty($afrbp_prices)) {

						// Product Price
						if ( '' != $afrbp_prices['discount_value'] || 0 != $afrbp_prices['discount_value'] ) {

							if ( '' != $afrbp_prices['min_qty'] || 0 != $afrbp_prices['min_qty'] ) {
								$min_qty = intval( $afrbp_prices['min_qty'] );
							} else {
								$min_qty = '';
							}

							if ( '' != $afrbp_prices['max_qty'] || 0 != $afrbp_prices['max_qty'] ) {
								$max_qty = intval( $afrbp_prices['max_qty'] );
							} else {
								$max_qty = '';
							}

							if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
								$csppdata      = false;
								$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
								$this->csp_wc_add_notice( $error_message );
								return $csppdata;

							} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

								$csppdata      = false;
								$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
								$this->csp_wc_add_notice( $error_message );
								return $csppdata;

							} else {
								return true;
							}
						}
					}

					// Rules
					if ( true ) {

						if ( empty( $_SESSION['allfetchedrules'] ) ) {

							echo '';

						} else {

							$all_rules = $_SESSION['allfetchedrules'];

						}

						if ( ! empty( $all_rules ) ) {
							foreach ( $all_rules as $rule ) {

								$istrue = false;

								$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

								if ( 'yes' == $applied_on_all_products ) {
									$istrue = true;
								} elseif ( ! empty( $rule->ProductsSession ) && in_array( $variation_id, $rule->ProductsSession ) || in_array( $prod->get_parent_id(), $rule->ProductsSession ) ) {
									$istrue = true;
								}

								if ( $istrue ) {

									// get Rule customer specifc price
									$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

									// get role base price
									foreach ( $user->roles as $value ) {

										$rule_role_base_price = get_post_meta( $rule->ID, 'rrole_base_price_' . $value, true );

										$rule_afrbp_prices = unserialize( $rule_role_base_price );

										if ( empty( $rule_afrbp_prices['discount_value'] ) || empty( $rule_afrbp_prices['discount_type'] ) ) {
											continue;
										} else {
											break;
										}
									}

									if ( ! empty( $rule_cus_base_price ) ) {
										foreach ( $rule_cus_base_price as $rule_cus_price ) {

											if ( $user->ID == $rule_cus_price['customer_name'] ) {

												if ( '' != $rule_cus_price['discount_value'] || 0 != $rule_cus_price['discount_value'] ) {

													if ( '' != $rule_cus_price['min_qty'] || 0 != $rule_cus_price['min_qty'] ) {
														$min_qty = intval( $rule_cus_price['min_qty'] );
													} else {
														$min_qty = '';
													}

													if ( '' != $rule_cus_price['max_qty'] || 0 != $rule_cus_price['max_qty'] ) {
														$max_qty = intval( $rule_cus_price['max_qty'] );
													} else {
														$max_qty = '';
													}

													if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
														$csppdata      = false;
														$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
														$this->csp_wc_add_notice( $error_message );
														return $csppdata;

													} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

														$csppdata      = false;
														$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
														$this->csp_wc_add_notice( $error_message );
														return $csppdata;

													} else {
														return true;
													}
												}
											}
										}
									}

									// Role Based Pricing
									// chcek if there is customer specific pricing then role base pricing will not work.
									if ( true && !empty($rule_afrbp_prices) ) {

										// Product Price
										if ( '' != $rule_afrbp_prices['discount_value'] || 0 != $rule_afrbp_prices['discount_value'] ) {

											if ( '' != $rule_afrbp_prices['min_qty'] || 0 != $rule_afrbp_prices['min_qty'] ) {
												$min_qty = intval( $rule_afrbp_prices['min_qty'] );
											} else {
												$min_qty = '';
											}

											if ( '' != $rule_afrbp_prices['max_qty'] || 0 != $rule_afrbp_prices['max_qty'] ) {
												$max_qty = intval( $rule_afrbp_prices['max_qty'] );
											} else {
												$max_qty = '';
											}

											if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
												$csppdata      = false;
												$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
												$this->csp_wc_add_notice( $error_message );
												return $csppdata;

											} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

												$csppdata      = false;
												$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
												$this->csp_wc_add_notice( $error_message );
												return $csppdata;

											} else {
												return true;
											}
										}
									}
								}
							}
						}
					}
				}
			} else {

				// For Guest Users

				if ( 0 == $variation_id ) {
					// Simple Product

					$targeted_id = $product_id;

					foreach ( WC()->cart->get_cart() as $cart_item ) {
						if ( $cart_item['product_id'] == $targeted_id ) {
							$oqty = $cart_item['quantity'];
							break; // stop the loop if product is found
						}
					}
					// Displaying the quantity if targeted product is in cart
					if ( ! empty( $oqty ) ) {

						$old_qty = $oqty;
					} else {
						$old_qty = 0;
					}

					// get customer specifc price
					$cus_base_price = get_post_meta( $product_id, '_cus_base_price', true );

					// get role base price
					$role_base_price_guest = get_post_meta( $product_id, '_role_base_price_guest', true );
					$afrbp_prices_guest    = unserialize( $role_base_price_guest );

					// Role Based Pricing
					// chcek if there is customer specific pricing then role base pricing will not work.
					if ( true ) {

						// Product Price
						if ( '' != $afrbp_prices_guest['discount_value'] || 0 != $afrbp_prices_guest['discount_value'] ) {

							if ( '' != $afrbp_prices_guest['min_qty'] || 0 != $afrbp_prices_guest['min_qty'] ) {
								$min_qty = intval( $afrbp_prices_guest['min_qty'] );
							} else {
								$min_qty = '';
							}

							if ( '' != $afrbp_prices_guest['max_qty'] || 0 != $afrbp_prices_guest['max_qty'] ) {
								$max_qty = intval( $afrbp_prices_guest['max_qty'] );
							} else {
								$max_qty = '';
							}

							if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
								$csppdata      = false;
								$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
								$this->csp_wc_add_notice( $error_message );
								return $csppdata;

							} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

								$csppdata      = false;
								$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
								$this->csp_wc_add_notice( $error_message );
								return $csppdata;

							} else {
								return true;
							}
						}
					}

					// Rules - guest users
					if ( true ) {

						if ( empty( $_SESSION['allfetchedrules'] ) ) {

							echo '';

						} else {

							$all_rules = $_SESSION['allfetchedrules'];

						}

						if ( ! empty( $all_rules ) ) {
							foreach ( $all_rules as $rule ) {

								$istrue = false;

								$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

								if ( 'yes' == $applied_on_all_products ) {
									$istrue = true;
								} elseif ( ! empty( $rule->ProductsSession ) && in_array( $product_id, $rule->ProductsSession ) ) {
									$istrue = true;
								}

								if ( $istrue ) {

									// get Rule customer specifc price
									$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

									// get role base price
									$rule_role_base_price_guest = get_post_meta( $rule->ID, 'rrole_base_price_guest', true );
									$rule_afrbp_prices_guest    = unserialize( $rule_role_base_price_guest );

									// Role Based Pricing
									// chcek if there is customer specific pricing then role base pricing will not work.
									if ( true ) {

										if ( '' != $rule_afrbp_prices_guest['discount_value'] || 0 != $rule_afrbp_prices_guest['discount_value'] ) {

											if ( '' != $rule_afrbp_prices_guest['min_qty'] || 0 != $rule_afrbp_prices_guest['min_qty'] ) {
												$min_qty = intval( $rule_afrbp_prices_guest['min_qty'] );
											} else {
												$min_qty = '';
											}

											if ( '' != $rule_afrbp_prices_guest['max_qty'] || 0 != $rule_afrbp_prices_guest['max_qty'] ) {
												$max_qty = intval( $rule_afrbp_prices_guest['max_qty'] );
											} else {
												$max_qty = '';
											}

											if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
												$csppdata      = false;
												$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
												$this->csp_wc_add_notice( $error_message );
												return $csppdata;

											} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

												$csppdata      = false;
												$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
												$this->csp_wc_add_notice( $error_message );
												return $csppdata;

											} else {
												return true;
											}
										}
									}
								}
							}
						}
					}
				} else {

					// Variable Product

					$targeted_id = $variation_id;

					foreach ( WC()->cart->get_cart() as $cart_item ) {
						if ( $cart_item['variation_id'] == $targeted_id ) {
							$oqty = $cart_item['quantity'];
							break; // stop the loop if product is found
						}
					}
					// Displaying the quantity if targeted product is in cart
					if ( ! empty( $oqty ) ) {

						$old_qty = $oqty;
					} else {
						$old_qty = 0;
					}

					// get customer specifc price
					$cus_base_price = get_post_meta( $variation_id, '_cus_base_price', true );

					// get role base price
					$role_base_price_guest = get_post_meta( $variation_id, '_role_base_price_guest', true );
					$afrbp_prices_guest    = unserialize( $role_base_price_guest );

					// Role Based Pricing
					// chcek if there is customer specific pricing then role base pricing will not work.
					if ( true && !empty($afrbp_prices_guest) ) {

						// Product Price
						if ( '' != $afrbp_prices_guest['discount_value'] || 0 != $afrbp_prices_guest['discount_value'] ) {

							if ( '' != $afrbp_prices_guest['min_qty'] || 0 != $afrbp_prices_guest['min_qty'] ) {
								$min_qty = intval( $afrbp_prices_guest['min_qty'] );
							} else {
								$min_qty = '';
							}

							if ( '' != $afrbp_prices_guest['max_qty'] || 0 != $afrbp_prices_guest['max_qty'] ) {
								$max_qty = intval( $afrbp_prices_guest['max_qty'] );
							} else {
								$max_qty = '';
							}

							if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
								$csppdata      = false;
								$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
								$this->csp_wc_add_notice( $error_message );
								return $csppdata;

							} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

								$csppdata      = false;
								$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
								$this->csp_wc_add_notice( $error_message );
								return $csppdata;

							} else {
								return true;
							}
						}
					}

					// Rules - guest users
					if ( true ) {

						if ( empty( $_SESSION['allfetchedrules'] ) ) {

							echo '';

						} else {

							$all_rules = $_SESSION['allfetchedrules'];

						}

						if ( ! empty( $all_rules ) ) {
							foreach ( $all_rules as $rule ) {

								$istrue = false;

								$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

								if ( 'yes' == $applied_on_all_products ) {
									$istrue = true;
								} elseif ( ! empty( $rule->ProductsSession ) && in_array( $variation_id, $rule->ProductsSession ) || in_array( $prod->get_parent_id(), $rule->ProductsSession ) ) {
									$istrue = true;
								}

								if ( $istrue ) {

									// get Rule customer specifc price
									$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

									// get role base price
									$rule_role_base_price_guest = get_post_meta( $rule->ID, 'rrole_base_price_guest', true );
									$rule_afrbp_prices_guest    = unserialize( $rule_role_base_price_guest );

									// Role Based Pricing
									// chcek if there is customer specific pricing then role base pricing will not work.
									if ( true ) {

										if ( '' != $rule_afrbp_prices_guest['discount_value'] || 0 != $rule_afrbp_prices_guest['discount_value'] ) {

											if ( '' != $rule_afrbp_prices_guest['min_qty'] || 0 != $rule_afrbp_prices_guest['min_qty'] ) {
												$min_qty = intval( $rule_afrbp_prices_guest['min_qty'] );
											} else {
												$min_qty = '';
											}

											if ( '' != $rule_afrbp_prices_guest['max_qty'] || 0 != $rule_afrbp_prices_guest['max_qty'] ) {
												$max_qty = intval( $rule_afrbp_prices_guest['max_qty'] );
											} else {
												$max_qty = '';
											}

											if ( '' != $min_qty && $old_qty + $qty < $min_qty ) {
												$csppdata      = false;
												$error_message = sprintf( get_option( 'csp_min_qty_error_msg' ), $min_qty );
												$this->csp_wc_add_notice( $error_message );
												return $csppdata;

											} elseif ( '' != $max_qty && $old_qty + $qty > $max_qty ) {

												$csppdata      = false;
												$error_message = sprintf( get_option( 'csp_max_qty_error_msg' ), $max_qty );
												$this->csp_wc_add_notice( $error_message );
												return $csppdata;

											} else {
												return true;
											}
										}
									}
								}
							}
						}
					}
				}
			}

			return $csppdata;

		}

		public function csp_update_cart_quantity_validation( $passed, $cart_item_key, $values, $qty ) {

			$user = wp_get_current_user();

			if ( is_user_logged_in() ) {

				if ( 0 == $values['variation_id'] ) {
					// Simple Product
					// get customer specifc price
					$pro            = wc_get_product( $values['product_id'] );
					$cus_base_price = get_post_meta( $values['product_id'], '_cus_base_price', true );

					// get role base price
					foreach ( $user->roles as $value ) {

						$role_base_price = get_post_meta( $values['product_id'], '_role_base_price_' . $value, true );

						$afrbp_prices = unserialize( $role_base_price );

						if ( empty( $afrbp_prices['discount_value'] ) || empty( $afrbp_prices['discount_type'] ) ) {
							continue;
						} else {
							break;
						}
					}

					if ( ! empty( $cus_base_price ) ) {
						foreach ( $cus_base_price as $cus_price ) {

							if ( $user->ID == $cus_price['customer_name'] ) {

								if ( '' != $cus_price['discount_value'] || 0 != $cus_price['discount_value'] ) {

									if ( '' != $cus_price['min_qty'] || 0 != $cus_price['min_qty'] ) {
										$min_qty = intval( $cus_price['min_qty'] );
									} else {
										$min_qty = '';
									}

									if ( '' != $cus_price['max_qty'] || 0 != $cus_price['max_qty'] ) {
										$max_qty = intval( $cus_price['max_qty'] );
									} else {
										$max_qty = '';
									}

									if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
										$passed        = false;
										$arr           = array(
											'%pro' => $pro->get_title(),
											'%min' => $min_qty,
											'%max' => $max_qty,
										);
										$word          = get_option( 'csp_update_cart_error_msg' );
										$error_message = strtr( $word, $arr );

										$this->csp_wc_add_notice( $error_message );
										return $passed;

									} else {
										return $passed;
									}
								}
							}
						}
					}

					// Role Based Pricing
					// chcek if there is customer specific pricing then role base pricing will not work.
					if ( true && !empty($afrbp_prices) ) {

						// Product Price
						if ( '' != $afrbp_prices['discount_value'] || 0 != $afrbp_prices['discount_value'] ) {

							if ( '' != $afrbp_prices['min_qty'] || 0 != $afrbp_prices['min_qty'] ) {
								$min_qty = intval( $afrbp_prices['min_qty'] );
							} else {
								$min_qty = '';
							}

							if ( '' != $afrbp_prices['max_qty'] || 0 != $afrbp_prices['max_qty'] ) {
								$max_qty = intval( $afrbp_prices['max_qty'] );
							} else {
								$max_qty = '';
							}

							if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
								$passed        = false;
								$arr           = array(
									'%pro' => $pro->get_title(),
									'%min' => $min_qty,
									'%max' => $max_qty,
								);
								$word          = get_option( 'csp_update_cart_error_msg' );
								$error_message = strtr( $word, $arr );

								$this->csp_wc_add_notice( $error_message );
								return $passed;

							} else {
								return $passed;
							}
						}
					}

					// Rules
					if ( true ) {

						if ( empty( $_SESSION['allfetchedrules'] ) ) {

							echo '';

						} else {

							$all_rules = $_SESSION['allfetchedrules'];

						}

						if ( ! empty( $all_rules ) ) {
							foreach ( $all_rules as $rule ) {

								$istrue = false;

								$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

								if ( 'yes' == $applied_on_all_products ) {
									$istrue = true;
								} elseif ( ! empty( $rule->ProductsSession ) && in_array( $values['product_id'], $rule->ProductsSession ) ) {
									$istrue = true;
								}

								if ( $istrue ) {

									// get Rule customer specifc price
									$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

									// get role base price
									foreach ( $user->roles as $value ) {

										$rule_role_base_price = get_post_meta( $rule->ID, 'rrole_base_price_' . $value, true );

										$rule_afrbp_prices = unserialize( $rule_role_base_price );

										if ( empty( $rule_afrbp_prices['discount_value'] ) || empty( $rule_afrbp_prices['discount_type'] ) ) {
											continue;
										} else {
											break;
										}
									}

									if ( ! empty( $rule_cus_base_price ) ) {
										foreach ( $rule_cus_base_price as $rule_cus_price ) {

											if ( $user->ID == $rule_cus_price['customer_name'] ) {

												if ( '' != $rule_cus_price['discount_value'] || 0 != $rule_cus_price['discount_value'] ) {

													if ( '' != $rule_cus_price['min_qty'] || 0 != $rule_cus_price['min_qty'] ) {
														$min_qty = intval( $rule_cus_price['min_qty'] );
													} else {
														$min_qty = '';
													}

													if ( '' != $rule_cus_price['max_qty'] || 0 != $rule_cus_price['max_qty'] ) {
														$max_qty = intval( $rule_cus_price['max_qty'] );
													} else {
														$max_qty = '';
													}

													if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
														$passed        = false;
														$arr           = array(
															'%pro' => $pro->get_title(),
															'%min' => $min_qty,
															'%max' => $max_qty,
														);
														$word          = get_option( 'csp_update_cart_error_msg' );
														$error_message = strtr( $word, $arr );

														$this->csp_wc_add_notice( $error_message );
														return $passed;

													} else {
														return $passed;
													}
												}
											}
										}
									}

									// Role Based Pricing
									// chcek if there is customer specific pricing then role base pricing will not work.
									if ( true && !empty($rule_afrbp_prices) ) {

										// Product Price
										if ( '' != $rule_afrbp_prices['discount_value'] || 0 != $rule_afrbp_prices['discount_value'] ) {

											if ( '' != $rule_afrbp_prices['min_qty'] || 0 != $rule_afrbp_prices['min_qty'] ) {
												$min_qty = intval( $rule_afrbp_prices['min_qty'] );
											} else {
												$min_qty = '';
											}

											if ( '' != $rule_afrbp_prices['max_qty'] || 0 != $rule_afrbp_prices['max_qty'] ) {
												$max_qty = intval( $rule_afrbp_prices['max_qty'] );
											} else {
												$max_qty = '';
											}

											if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
												$passed        = false;
												$arr           = array(
													'%pro' => $pro->get_title(),
													'%min' => $min_qty,
													'%max' => $max_qty,
												);
												$word          = get_option( 'csp_update_cart_error_msg' );
												$error_message = strtr( $word, $arr );

												$this->csp_wc_add_notice( $error_message );
												return $passed;

											} else {
												return $passed;
											}
										}
									}
								}
							}
						}
					}
				} else {

					// Variable Product
					// get customer specifc price
					$pro            = wc_get_product( $values['variation_id'] );
					$cus_base_price = get_post_meta( $values['variation_id'], '_cus_base_price', true );

					// get role base price
					foreach ( $user->roles as $value ) {

						$role_base_price = get_post_meta( $values['variation_id'], '_role_base_price_' . $value, true );

						$afrbp_prices = unserialize( $role_base_price );

						if ( empty( $afrbp_prices['discount_value'] ) || empty( $afrbp_prices['discount_type'] ) ) {
							continue;
						} else {
							break;
						}
					}

					if ( ! empty( $cus_base_price ) ) {
						foreach ( $cus_base_price as $cus_price ) {

							if ( $user->ID == $cus_price['customer_name'] ) {

								if ( '' != $cus_price['discount_value'] || 0 != $cus_price['discount_value'] ) {

									if ( '' != $cus_price['min_qty'] || 0 != $cus_price['min_qty'] ) {
										$min_qty = intval( $cus_price['min_qty'] );
									} else {
										$min_qty = '';
									}

									if ( '' != $cus_price['max_qty'] || 0 != $cus_price['max_qty'] ) {
										$max_qty = intval( $cus_price['max_qty'] );
									} else {
										$max_qty = '';
									}

									if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
										$passed        = false;
										$arr           = array(
											'%pro' => $pro->get_title(),
											'%min' => $min_qty,
											'%max' => $max_qty,
										);
										$word          = get_option( 'csp_update_cart_error_msg' );
										$error_message = strtr( $word, $arr );

										$this->csp_wc_add_notice( $error_message );
										return $passed;

									} else {
										return $passed;
									}
								}
							}
						}
					}

					// Role Based Pricing
					// chcek if there is customer specific pricing then role base pricing will not work.
					if ( true && !empty($afrbp_prices) ) {

						// Product Price
						if ( '' != $afrbp_prices['discount_value'] || 0 != $afrbp_prices['discount_value'] ) {

							if ( '' != $afrbp_prices['min_qty'] || 0 != $afrbp_prices['min_qty'] ) {
								$min_qty = intval( $afrbp_prices['min_qty'] );
							} else {
								$min_qty = '';
							}

							if ( '' != $afrbp_prices['max_qty'] || 0 != $afrbp_prices['max_qty'] ) {
								$max_qty = intval( $afrbp_prices['max_qty'] );
							} else {
								$max_qty = '';
							}

							if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
								$passed        = false;
								$arr           = array(
									'%pro' => $pro->get_title(),
									'%min' => $min_qty,
									'%max' => $max_qty,
								);
								$word          = get_option( 'csp_update_cart_error_msg' );
								$error_message = strtr( $word, $arr );

								$this->csp_wc_add_notice( $error_message );
								return $passed;

							} else {
								return $passed;
							}
						}
					}

					// Rules
					if ( true ) {

						if ( empty( $_SESSION['allfetchedrules'] ) ) {

							echo '';

						} else {

							$all_rules = $_SESSION['allfetchedrules'];

						}

						if ( ! empty( $all_rules ) ) {
							foreach ( $all_rules as $rule ) {

								$istrue = false;

								$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

								if ( 'yes' == $applied_on_all_products ) {
									$istrue = true;
								} elseif ( ! empty( $rule->ProductsSession ) && in_array( $values['variation_id'], $rule->ProductsSession ) || in_array( $pro->get_parent_id(), $rule->ProductsSession ) ) {
									$istrue = true;
								}

								if ( $istrue ) {

									// get Rule customer specifc price
									$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

									// get role base price
									foreach ( $user->roles as $value ) {

										$rule_role_base_price = get_post_meta( $rule->ID, 'rrole_base_price_' . $value, true );

										$rule_afrbp_prices = unserialize( $rule_role_base_price );

										if ( empty( $rule_afrbp_prices['discount_value'] ) || empty( $rule_afrbp_prices['discount_type'] ) ) {
											continue;
										} else {
											break;
										}
									}

									if ( ! empty( $rule_cus_base_price ) ) {
										foreach ( $rule_cus_base_price as $rule_cus_price ) {

											if ( $user->ID == $rule_cus_price['customer_name'] ) {

												if ( '' != $rule_cus_price['discount_value'] || 0 != $rule_cus_price['discount_value'] ) {

													if ( '' != $rule_cus_price['min_qty'] || 0 != $rule_cus_price['min_qty'] ) {
														$min_qty = intval( $rule_cus_price['min_qty'] );
													} else {
														$min_qty = '';
													}

													if ( '' != $rule_cus_price['max_qty'] || 0 != $rule_cus_price['max_qty'] ) {
														$max_qty = intval( $rule_cus_price['max_qty'] );
													} else {
														$max_qty = '';
													}

													if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
														$passed        = false;
														$arr           = array(
															'%pro' => $pro->get_title(),
															'%min' => $min_qty,
															'%max' => $max_qty,
														);
														$word          = get_option( 'csp_update_cart_error_msg' );
														$error_message = strtr( $word, $arr );

														$this->csp_wc_add_notice( $error_message );

													} else {
														return $passed;
													}
												}
											}
										}
									}

									// Role Based Pricing
									// chcek if there is customer specific pricing then role base pricing will not work.
									if ( true && !empty($rule_afrbp_prices) ) {

										// Product Price
										if ( '' != $rule_afrbp_prices['discount_value'] || 0 != $rule_afrbp_prices['discount_value'] ) {

											if ( '' != $rule_afrbp_prices['min_qty'] || 0 != $rule_afrbp_prices['min_qty'] ) {
												$min_qty = intval( $rule_afrbp_prices['min_qty'] );
											} else {
												$min_qty = '';
											}

											if ( '' != $rule_afrbp_prices['max_qty'] || 0 != $rule_afrbp_prices['max_qty'] ) {
												$max_qty = intval( $rule_afrbp_prices['max_qty'] );
											} else {
												$max_qty = '';
											}

											if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
												$passed        = false;
												$arr           = array(
													'%pro' => $pro->get_title(),
													'%min' => $min_qty,
													'%max' => $max_qty,
												);
												$word          = get_option( 'csp_update_cart_error_msg' );
												$error_message = strtr( $word, $arr );

												$this->csp_wc_add_notice( $error_message );
												return $passed;

											} else {
												return $passed;
											}
										}
									}
								}
							}
						}
					}
				}
			} else {

				// For Guest Users
				if ( 0 == $values['variation_id'] ) {
					// Simeple Products
					// get customer specifc price
					$pro            = wc_get_product( $values['product_id'] );
					$cus_base_price = get_post_meta( $values['product_id'], '_cus_base_price', true );

					// get role base price
					$role_base_price_guest = get_post_meta( $values['product_id'], '_role_base_price_guest', true );
					$afrbp_prices_guest    = unserialize( $role_base_price_guest );

					// Role Based Pricing
					// chcek if there is customer specific pricing then role base pricing will not work.
					if ( true && !empty($afrbp_prices_guest) ) {

						// Product Price
						if ( '' != $afrbp_prices_guest['discount_value'] || 0 != $afrbp_prices_guest['discount_value'] ) {

							if ( '' != $afrbp_prices_guest['min_qty'] || 0 != $afrbp_prices_guest['min_qty'] ) {
								$min_qty = intval( $afrbp_prices_guest['min_qty'] );
							} else {
								$min_qty = '';
							}

							if ( '' != $afrbp_prices_guest['max_qty'] || 0 != $afrbp_prices_guest['max_qty'] ) {
								$max_qty = intval( $afrbp_prices_guest['max_qty'] );
							} else {
								$max_qty = '';
							}

							if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
								$passed        = false;
								$arr           = array(
									'%pro' => $pro->get_title(),
									'%min' => $min_qty,
									'%max' => $max_qty,
								);
								$word          = get_option( 'csp_update_cart_error_msg' );
								$error_message = strtr( $word, $arr );

								$this->csp_wc_add_notice( $error_message );
								return $passed;

							} else {
								return $passed;
							}
						}
					}

					// Rule - Guest Users

					// Rules - guest users
					if ( true ) {

						if ( empty( $_SESSION['allfetchedrules'] ) ) {

							echo '';

						} else {

							$all_rules = $_SESSION['allfetchedrules'];

						}

						if ( ! empty( $all_rules ) ) {
							foreach ( $all_rules as $rule ) {

								$istrue = false;

								$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

								if ( 'yes' == $applied_on_all_products ) {
									$istrue = true;
								} elseif ( ! empty( $rule->ProductsSession ) && in_array( $values['product_id'], $rule->ProductsSession ) ) {
									$istrue = true;
								}

								if ( $istrue ) {

									// get Rule customer specifc price
									$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

									// get role base price
									$rule_role_base_price_guest = get_post_meta( $rule->ID, 'rrole_base_price_guest', true );
									$rule_afrbp_prices_guest    = unserialize( $rule_role_base_price_guest );

									// Role Based Pricing
									// chcek if there is customer specific pricing then role base pricing will not work.
									if ( true && !empty($rule_afrbp_prices_guest) ) {

										// Product Price
										if ( '' != $rule_afrbp_prices_guest['discount_value'] || 0 != $rule_afrbp_prices_guest['discount_value'] ) {

											if ( '' != $rule_afrbp_prices_guest['min_qty'] || 0 != $rule_afrbp_prices_guest['min_qty'] ) {
												$min_qty = intval( $rule_afrbp_prices_guest['min_qty'] );
											} else {
												$min_qty = '';
											}

											if ( '' != $rule_afrbp_prices_guest['max_qty'] || 0 != $rule_afrbp_prices_guest['max_qty'] ) {
												$max_qty = intval( $rule_afrbp_prices_guest['max_qty'] );
											} else {
												$max_qty = '';
											}

											if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
												$passed        = false;
												$arr           = array(
													'%pro' => $pro->get_title(),
													'%min' => $min_qty,
													'%max' => $max_qty,
												);
												$word          = get_option( 'csp_update_cart_error_msg' );
												$error_message = strtr( $word, $arr );

												$this->csp_wc_add_notice( $error_message );
												return $passed;

											} else {
												return $passed;
											}
										}
									}
								}
							}
						}
					}
				} else {
					// Variable Products

					// Simeple Products
					// get customer specifc price
					$pro            = wc_get_product( $values['variation_id'] );
					$cus_base_price = get_post_meta( $values['variation_id'], '_cus_base_price', true );

					// get role base price
					$role_base_price_guest = get_post_meta( $values['variation_id'], '_role_base_price_guest', true );
					$afrbp_prices_guest    = unserialize( $role_base_price_guest );

					// Role Based Pricing
					// chcek if there is customer specific pricing then role base pricing will not work.
					if ( true && !empty($afrbp_prices_guest) ) {

						// Product Price
						if ( '' != $afrbp_prices_guest['discount_value'] || 0 != $afrbp_prices_guest['discount_value'] ) {

							if ( '' != $afrbp_prices_guest['min_qty'] || 0 != $afrbp_prices_guest['min_qty'] ) {
								$min_qty = intval( $afrbp_prices_guest['min_qty'] );
							} else {
								$min_qty = '';
							}

							if ( '' != $afrbp_prices_guest['max_qty'] || 0 != $afrbp_prices_guest['max_qty'] ) {
								$max_qty = intval( $afrbp_prices_guest['max_qty'] );
							} else {
								$max_qty = '';
							}

							if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
								$passed        = false;
								$arr           = array(
									'%pro' => $pro->get_title(),
									'%min' => $min_qty,
									'%max' => $max_qty,
								);
								$word          = get_option( 'csp_update_cart_error_msg' );
								$error_message = strtr( $word, $arr );

								$this->csp_wc_add_notice( $error_message );
								return $passed;

							} else {
								return $passed;
							}
						}
					}

					// Rule - Guest Users

					// Rules - guest users
					if ( true ) {

						if ( empty( $_SESSION['allfetchedrules'] ) ) {

							echo '';

						} else {

							$all_rules = $_SESSION['allfetchedrules'];

						}

						if ( ! empty( $all_rules ) ) {
							foreach ( $all_rules as $rule ) {

								$istrue = false;

								$applied_on_all_products = get_post_meta( $rule->ID, 'csp_apply_on_all_products', true );

								if ( 'yes' == $applied_on_all_products ) {
									$istrue = true;
								} elseif ( ! empty( $rule->ProductsSession ) && in_array( $values['variation_id'], $rule->ProductsSession ) || in_array( $pro->get_parent_id(), $rule->ProductsSession ) ) {
									$istrue = true;
								}

								if ( $istrue ) {

									// get Rule customer specifc price
									$rule_cus_base_price = get_post_meta( $rule->ID, 'rcus_base_price', true );

									// get role base price
									$rule_role_base_price_guest = get_post_meta( $rule->ID, 'rrole_base_price_guest', true );
									$rule_afrbp_prices_guest    = unserialize( $rule_role_base_price_guest );

									// Role Based Pricing
									// chcek if there is customer specific pricing then role base pricing will not work.
									if ( true ) {

										// Product Price
										if ( '' != $rule_afrbp_prices_guest['discount_value'] || 0 != $rule_afrbp_prices_guest['discount_value'] ) {

											if ( '' != $rule_afrbp_prices_guest['min_qty'] || 0 != $rule_afrbp_prices_guest['min_qty'] ) {
												$min_qty = intval( $rule_afrbp_prices_guest['min_qty'] );
											} else {
												$min_qty = '';
											}

											if ( '' != $rule_afrbp_prices_guest['max_qty'] || 0 != $rule_afrbp_prices_guest['max_qty'] ) {
												$max_qty = intval( $rule_afrbp_prices_guest['max_qty'] );
											} else {
												$max_qty = '';
											}

											if ( ( '' != $min_qty && $qty < $min_qty ) || ( '' != $max_qty && $qty > $max_qty ) ) {
												$passed        = false;
												$arr           = array(
													'%pro' => $pro->get_title(),
													'%min' => $min_qty,
													'%max' => $max_qty,
												);
												$word          = get_option( 'csp_update_cart_error_msg' );
												$error_message = strtr( $word, $arr );

												$this->csp_wc_add_notice( $error_message );
												return $passed;

											} else {
												return $passed;
											}
										}
									}
								}
							}
						}
					}
				}
			}

			return $passed;

		}

		public function csp_wc_add_notice( $string, $type = 'error' ) {

			global $woocommerce;
			if ( version_compare( $woocommerce->version, 2.1, '>=' ) ) {
				wc_add_notice( $string, $type );
			} else {
				$woocommerce->add_error( $string );
			}

		}

		public function csp_replace_loop_add_to_cart_link( $html, $product ) {

			$cart_txt = $html;

			$enable_hide_price_feature        = get_option( 'csp_enable_hide_pirce' );
			$enable_for_guest                 = get_option( 'csp_enable_hide_pirce_guest' );
			$csp_enable_hide_pirce_registered = get_option( 'csp_enable_hide_pirce_registered' );
			$csp_hide_user_role               = unserialize( get_option( 'csp_hide_user_role' ) );

			$enable_hide_price = get_option( 'csp_hide_price' );
			$cps_price_text    = get_option( 'csp_price_text' );

			$csp_hide_cart_button = get_option( 'csp_hide_cart_button' );
			$csp_cart_button_text = get_option( 'csp_cart_button_text' );
			$csp_cart_button_link = get_option( 'csp_cart_button_link' );

			$csp_hide_products   = unserialize( get_option( 'csp_hide_products' ) );
			$cps_hide_categories = unserialize( get_option( 'cps_hide_categories' ) );

			// Hide add to cart if price is hidden because there is no need of button if price is hidden.

			if ( empty( $enable_hide_price_feature ) || 'yes' != $enable_hide_price_feature ) {
				return $html;
			} elseif ( empty( $csp_hide_cart_button ) || 'yes' != $csp_hide_cart_button ) {
				return $html;
			}

			if ( ! empty( $enable_hide_price_feature ) && 'yes' == $enable_hide_price_feature ) {

				// For Guest Users
				if ( ! empty( $enable_for_guest ) && 'yes' == $enable_for_guest ) {
					if ( ! is_user_logged_in() ) {
						if ( ! empty( $csp_hide_products ) ) {
							if ( in_array( $product->get_id(), $csp_hide_products ) ) {

								if ( ! empty( $csp_hide_cart_button ) && 'yes' == $csp_hide_cart_button ) {

									if ( ! empty( $csp_cart_button_text ) ) {

										$cart_txt = '<a href="' . esc_url( $csp_cart_button_link ) . '" rel="nofollow" class="button add_to_cart_button">' . esc_attr( $csp_cart_button_text ) . '</a>';

									} else {
										$cart_txt = '';
									}
								}
							}
						} elseif ( ! empty( $cps_hide_categories ) ) {
							foreach ( $cps_hide_categories as $cat ) {
								if ( has_term( $cat, 'product_cat', $product->get_id() ) ) {
									if ( ! empty( $csp_cart_button_text ) ) {

										$cart_txt = '<a href="' . esc_url( $csp_cart_button_link ) . '" rel="nofollow" class="button add_to_cart_button">' . esc_attr( $csp_cart_button_text ) . '</a>';

									} else {
										$cart_txt = '';
									}
								}
							}
						}
					}
				}

				// For Registered Users
				if ( ! empty( $csp_enable_hide_pirce_registered ) && 'yes' == $csp_enable_hide_pirce_registered ) {

					if ( is_user_logged_in() ) {

						// get Current User Role
						$curr_user      = wp_get_current_user();
						$user_data      = get_user_meta( $curr_user->ID );
						$curr_user_role = $curr_user->roles[0];

						if ( in_array( $curr_user_role, $csp_hide_user_role ) ) {

							if ( in_array( $product->get_id(), (array) $csp_hide_products ) ) {

								if ( ! empty( $csp_hide_cart_button ) && 'yes' == $csp_hide_cart_button ) {

									if ( ! empty( $csp_cart_button_text ) ) {

										$cart_txt = '<a href="' . esc_url( $csp_cart_button_link ) . '" rel="nofollow" class="button add_to_cart_button">' . esc_attr( $csp_cart_button_text ) . '</a>';

									} else {
										$cart_txt = '';
									}
								}
							} elseif ( ! empty( $cps_hide_categories ) ) {
								foreach ( $cps_hide_categories as $cat ) {

									if ( has_term( $cat, 'product_cat', $product->get_id() ) ) {
										if ( ! empty( $enable_hide_price ) && 'yes' == $enable_hide_price ) {

											if ( ! empty( $csp_cart_button_text ) ) {

												$cart_txt = '<a href="' . esc_url( $csp_cart_button_link ) . '" rel="nofollow" class="button add_to_cart_button">' . esc_attr( $csp_cart_button_text ) . '</a>';

											} else {
												$cart_txt = '';
											}
											break;
										}
									}
								}
							}
						}
					}
				}
			}

			// Hide add to cart button if hidden in our module settings.
			if ( ! empty( $csp_hide_cart_button ) && 'yes' == $csp_hide_cart_button ) {

				// For Guest Users
				if ( ! empty( $enable_for_guest ) && 'yes' == $enable_for_guest ) {
					if ( ! is_user_logged_in() ) {
						if ( ! empty( $csp_hide_products ) ) {
							if ( in_array( $product->get_id(), $csp_hide_products ) ) {

								if ( ! empty( $csp_cart_button_text ) ) {

									$cart_txt = '<a href="' . esc_url( $csp_cart_button_link ) . '" rel="nofollow" class="button add_to_cart_button">' . esc_attr( $csp_cart_button_text ) . '</a>';

								} else {
									$cart_txt = '';
								}
							}
						} elseif ( ! empty( $cps_hide_categories ) ) {
							foreach ( $cps_hide_categories as $cat ) {

								if ( has_term( $cat, 'product_cat', $product->get_id() ) ) {
									if ( ! empty( $csp_hide_cart_button ) && 'yes' == $csp_hide_cart_button ) {

										if ( ! empty( $csp_cart_button_text ) ) {

											$cart_txt = '<a href="' . esc_url( $csp_cart_button_link ) . '" rel="nofollow" class="button add_to_cart_button">' . esc_attr( $csp_cart_button_text ) . '</a>';

										} else {
											$cart_txt = '';
										}
										break;
									}
								}
							}
						}
					}
				}

				// For Registered Users
				if ( ! empty( $csp_enable_hide_pirce_registered ) && 'yes' == $csp_enable_hide_pirce_registered ) {

					if ( is_user_logged_in() ) {

						// get Current User Role
						$curr_user      = wp_get_current_user();
						$user_data      = get_user_meta( $curr_user->ID );
						$curr_user_role = $curr_user->roles[0];

						if ( in_array( $curr_user_role, $csp_hide_user_role ) ) {

							if ( in_array( $product->get_id(), (array) $csp_hide_products ) ) {

								if ( ! empty( $csp_hide_cart_button ) && 'yes' == $csp_hide_cart_button ) {

									if ( ! empty( $csp_cart_button_text ) ) {

										$cart_txt = '<a href="' . esc_url( $csp_cart_button_link ) . '" rel="nofollow" class="button add_to_cart_button">' . esc_attr( $csp_cart_button_text ) . '</a>';

									} else {
										$cart_txt = '';
									}
								}
							} elseif ( ! empty( $cps_hide_categories ) ) {
								foreach ( $cps_hide_categories as $cat ) {

									if ( has_term( $cat, 'product_cat', $product->get_id() ) ) {
										if ( ! empty( $csp_hide_cart_button ) && 'yes' == $csp_hide_cart_button ) {

											if ( ! empty( $csp_cart_button_text ) ) {

												$cart_txt = '<a href="' . esc_url( $csp_cart_button_link ) . '" rel="nofollow" class="button add_to_cart_button">' . esc_attr( $csp_cart_button_text ) . '</a>';

											} else {
												$cart_txt = '';
											}
											break;
										}
									}
								}
							}
						}
					}
				}
			}

			return $cart_txt;

		}

		public function csp_hide_add_cart_product_page() {

			global $user, $product;

			$enable_hide_price_feature        = get_option( 'csp_enable_hide_pirce' );
			$enable_for_guest                 = get_option( 'csp_enable_hide_pirce_guest' );
			$csp_enable_hide_pirce_registered = get_option( 'csp_enable_hide_pirce_registered' );
			$csp_hide_user_role               = unserialize( get_option( 'csp_hide_user_role' ) );

			$enable_hide_price = get_option( 'csp_hide_price' );
			$cps_price_text    = get_option( 'csp_price_text' );

			$csp_hide_cart_button = get_option( 'csp_hide_cart_button' );
			$csp_cart_button_text = get_option( 'csp_cart_button_text' );
			$csp_cart_button_link = get_option( 'csp_cart_button_link' );

			$csp_hide_products   = unserialize( get_option( 'csp_hide_products' ) );
			$cps_hide_categories = unserialize( get_option( 'cps_hide_categories' ) );

			// Category Products

			$product_flag = false;
			if ( in_array( $product->get_id(), (array) $csp_hide_products ) ) {
				$product_flag = true;
			}

			$cat_flag = false;

			foreach ( (array) $cps_hide_categories as $cat) {
				if ( has_term( $cat, 'product_cat', $product->get_id() ) ) {
					$cat_flag = true;
					break;
				}
			}


			// Hide add to cart if price is hidden because there is no need of button if price is hidden.

			if ( ! empty( $enable_hide_price_feature ) && 'yes' == $enable_hide_price_feature ) {

				// For Guest Users
				if ( ! empty( $enable_for_guest ) && 'yes' == $enable_for_guest ) {
					if ( ! is_user_logged_in() ) {
						if ( ! empty( $csp_hide_products ) || $cat_flag ) {
							if ( in_array( $product->get_id(), $csp_hide_products ) || $cat_flag ) {

								if ( ! empty( $csp_hide_cart_button ) && 'yes' == $csp_hide_cart_button ) {

									if ( 'variable' == $product->get_type() ) {

										remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20 );
										add_action( 'woocommerce_single_variation', array( $this, 'csp_custom_button_replacement' ), 30 );

									} else {

										remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
										add_action( 'woocommerce_single_product_summary', array( $this, 'csp_custom_button_replacement' ), 30 );
									}
								}
							}
						}
					}
				}

				// For Registered Users
				if ( ! empty( $csp_enable_hide_pirce_registered ) && 'yes' == $csp_enable_hide_pirce_registered ) {

					if ( is_user_logged_in() ) {

						// get Current User Role
						$curr_user      = wp_get_current_user();
						$user_data      = get_user_meta( $curr_user->ID );
						$curr_user_role = $curr_user->roles[0];

						if ( in_array( $curr_user_role, $csp_hide_user_role ) && ( in_array( $product->get_id(), (array) $csp_hide_products ) || $cat_flag ) ) {

							if ( ! empty( $csp_hide_cart_button ) && 'yes' == $csp_hide_cart_button ) {

								if ( 'variable' == $product->get_type() ) {

									remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20 );
									add_action( 'woocommerce_single_variation', array( $this, 'csp_custom_button_replacement' ), 30 );

								} else {

									remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
									add_action( 'woocommerce_single_product_summary', array( $this, 'csp_custom_button_replacement' ), 30 );
								}
							}
						}
					}
				}

				// Hide add to cart button if hidden in our module settings.
				if ( ! empty( $csp_hide_cart_button ) && 'yes' == $csp_hide_cart_button ) {

					// For Guest Users
					if ( ! empty( $enable_for_guest ) && 'yes' == $enable_for_guest ) {
						if ( ! is_user_logged_in() ) {
							if ( ! empty( $csp_hide_products ) || $cat_flag ) {
								if ( in_array( $product->get_id(), (array) $csp_hide_products ) || $cat_flag ) {

									if ( 'variable' == $product->get_type() ) {

										remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20 );
										add_action( 'woocommerce_single_variation', array( $this, 'csp_custom_button_replacement' ), 30 );

									} else {

										remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
										add_action( 'woocommerce_single_product_summary', array( $this, 'csp_custom_button_replacement' ), 30 );
									}
								}
							}
						}
					}

					// For Registered Users
					if ( ! empty( $csp_enable_hide_pirce_registered ) && 'yes' == $csp_enable_hide_pirce_registered ) {

						if ( is_user_logged_in() ) {

							// get Current User Role
							$curr_user      = wp_get_current_user();
							$user_data      = get_user_meta( $curr_user->ID );
							$curr_user_role = $curr_user->roles[0];

							if ( in_array( $curr_user_role, $csp_hide_user_role ) && ( in_array( $product->get_id(), (array) $csp_hide_products ) || $cat_flag ) ) {

								if ( 'variable' == $product->get_type() ) {

									remove_action( 'woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20 );
									add_action( 'woocommerce_single_variation', array( $this, 'csp_custom_button_replacement' ), 30 );

								} else {

									remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
									add_action( 'woocommerce_single_product_summary', array( $this, 'csp_custom_button_replacement' ), 30 );
								}
							}
						}
					}
				}
			}
		}


		public function csp_custom_button_replacement() {

			global $user, $product;

			$enable_hide_price_feature        = get_option( 'csp_enable_hide_pirce' );
			$enable_for_guest                 = get_option( 'csp_enable_hide_pirce_guest' );
			$csp_enable_hide_pirce_registered = get_option( 'csp_enable_hide_pirce_registered' );
			$csp_hide_user_role               = unserialize( get_option( 'csp_hide_user_role' ) );

			$enable_hide_price = get_option( 'csp_hide_price' );
			$cps_price_text    = get_option( 'csp_price_text' );

			$csp_hide_cart_button = get_option( 'csp_hide_cart_button' );
			$csp_cart_button_text = get_option( 'csp_cart_button_text' );
			$csp_cart_button_link = get_option( 'csp_cart_button_link' );

			$csp_hide_products   = unserialize( get_option( 'csp_hide_products' ) );
			$cps_hide_categories = unserialize( get_option( 'cps_hide_categories' ) );

			if ( ! empty( $csp_cart_button_text ) ) {

				echo '<a href="' . esc_url( $csp_cart_button_link ) . '" rel="nofollow" class="button add_to_cart_button">' . esc_attr( $csp_cart_button_text ) . '</a>';

			} else {
				echo '';
			}

		}



	}

	new Front_Class_Addify_Customer_And_Role_Pricing();
}
