<?php

namespace Barn2\Plugin\WC_Product_Table\Compat;

use Barn2\Plugin\WC_Product_Table\Frontend_Scripts,
	Barn2\Plugin\WC_Product_Table\Util\Util,
	Barn2\WPT_Lib\Registerable,
	Barn2\WPT_Lib\Conditional,
	Barn2\WPT_Lib\Service,
	Barn2\WPT_Lib\Util as Lib_Util;

/**
 * Provides functions for compatibility and integration with different themes.
 *
 * @package   Barn2\woocommerce-product-table
 * @author    Barn2 Plugins <support@barn2.com>
 * @license   GPL-3.0
 * @copyright Barn2 Media Ltd
 */
class Theme_Compat implements Service, Registerable, Conditional {

	public function is_required() {
		return Lib_Util::is_front_end();
	}

	public function register() {
		$theme = strtolower( get_template() );
		add_action( 'wp_enqueue_scripts', [ $this, 'register_dequeued_scripts' ], 1000 );

		if ( 'kallyas' === $theme ) {
			add_filter( 'add_to_cart_fragments', [ $this, 'kallyas_ensure_valid_add_to_cart_fragments' ], 20 );
		} elseif ( 'uncode' === $theme ) {
			add_filter( 'add_to_cart_class', [ $this, 'uncode_child_add_to_cart_class' ] );
		} elseif ( 'x' === $theme ) {
			add_action( 'wp_enqueue_scripts', [ $this, 'x_remove_legacy_mediaelement_styles' ] );
		}

		if ( function_exists( 'wp_add_inline_script' ) && in_array( $theme, [ 'avada', 'enfold', 'flatsome', 'jupiter' ], true ) ) {
			add_action( 'wp_enqueue_scripts', [ $this, 'add_theme_inline_script' ], 50 );
		}
	}

	public function register_dequeued_scripts() {
		// Some themes take it upon themselves to remove core WC scripts which we rely on, so let's re-register them just in case.
		wp_register_style( 'select2', Util::get_wc_asset_url( 'css/select2.css' ), [], ( defined( 'WC_VERSION' ) ? WC_VERSION : '1.0' ) );
		wp_register_script( 'jquery-blockui', Util::get_wc_asset_url( 'js/jquery-blockui/jquery.blockUI.min.js' ), [ 'jquery' ], '2.70', true );
		wp_register_script( 'selectWoo', Util::get_wc_asset_url( 'js/selectWoo/selectWoo.full.min.js' ), [ 'jquery' ], '1.0.6', true );
	}

	public function kallyas_ensure_valid_add_to_cart_fragments( $fragments ) {
		if ( ! isset( $fragments['zn_added_to_cart'] ) ) {
			$fragments['zn_added_to_cart'] = '';
		}
		return $fragments;
	}

	public function uncode_child_add_to_cart_class( $class ) {
		return $class . ' single_add_to_cart_button';
	}

	public function x_remove_legacy_mediaelement_styles() {
		wp_dequeue_style( 'wp-mediaelement' );
		wp_deregister_style( 'wp-mediaelement' );
		wp_register_style( 'wp-mediaelement', '/wp-includes/js/mediaelement/wp-mediaelement.min.css' );
	}

	public function add_theme_inline_script() {
		$theme = strtolower( get_template() );
		$func  = "{$theme}_get_inline_script";

		if ( method_exists( $this, $func ) ) {
			wp_add_inline_script( Frontend_Scripts::SCRIPT_HANDLE, trim( $this->$func() ) );
		}
	}

	public function avada_get_inline_script() {
		return "
			( function( $ ) {
				// Remove Avada styling for select elements in product tables
				$( '.wc-product-table' ).on( 'load.wcpt', function() {
					$( this ).find( '.avada-select-parent' ).children( 'select' ).unwrap().siblings( '.select-arrow' ).remove();
				} );
				$( '.wc-product-table' ).on( 'responsive-display.wcpt draw.wcpt', function() {
					if ( !$( this ).hasClass( 'loading' ) && typeof avadaAddQuantityBoxes === 'function' ) {
						avadaAddQuantityBoxes();
					}
				});
			})( jQuery );";
	}

	public function enfold_get_inline_script() {
		return "
			( function( $ ) {
				var wcptOnQuantityButtonClick = function( event ) {
					// Prevent any other handlers changing the quantity
					event.stopImmediatePropagation();

					var clicked = $( this );
					var isMinus = clicked.is( '.minus' );

					clicked.closest( '.quantity' ).find( '.qty' ).val( function( i, value ) {
						var qty = $( this );
						value = parseFloat( value );
						var step = parseFloat( qty.prop( 'step' ) ), min = parseFloat( qty.prop( 'min' ) ), max = parseFloat( qty.prop( 'max' ) );

						value = !isNaN( value ) ? value : 1;
						step = !isNaN( step ) ? step : 1;
						min = !isNaN( min ) ? min : 1;
						max = !isNaN( max ) ? max : 9999;

						step = isMinus ? -1 * step : step;
						value = value + step;

						if ( isMinus ) {
							return Math.max( value, min );
						} else {
							return Math.min( value, max );
						}
					} ).trigger( 'change' );
				};

				var wcptOnDrawAddQuantityButtons = function( event ) {
					$( this ).find( '.cart div.quantity:not(.buttons_added)' )
						.addClass( 'buttons_added' )
						.children( '.qty' )
						.before( '<input type=\"button\" value=\"-\" class=\"minus\">' )
						.after( '<input type=\"button\" value=\"+\" class=\"plus\">' );
				};

				$( '.wc-product-table' )
					.on( 'click', '.quantity .plus, .quantity .minus', wcptOnQuantityButtonClick )
					.on( 'responsive-display.wcpt draw.wcpt', wcptOnDrawAddQuantityButtons );
			})( jQuery );";
	}

	public function flatsome_get_inline_script() {
		return "
			( function( $ ) {
				$( '.wc-product-table' ).on( 'responsive-display.wcpt draw.wcpt', function() {
					if ( $.fn.addQty ) {
						$( this )
							.find( '.cart .quantity' )
							.remove( '.plus', '.minus' )
							.addQty();
					}
				});
			})( jQuery );";
	}

	public function jupiter_get_inline_script() {
		return "
			( function( $ ) {
				$( '.wc-product-table' ).on( 'responsive-display.wcpt', function( e, table, childRow ) {
					childRow.find( 'div.quantity:not(.buttons_added)' ).addClass( 'buttons_added' ).append( '<input type=\"button\" value=\"+\" class=\"plus\" />' ).prepend( '<input type=\"button\" value=\"-\" class=\"minus\" />' );
				});
			})( jQuery );";
	}

}
