var wc_custom_payment_fields_meta = {
	text : {
		fields: 
			[
					{
						type : 'text',
						name : 'Name',
					},
					{
						name: 'Description',
						type: 'textarea',
					},
					{
						type: 'select',
						name: 'Size',
						options: [
							{ 
								key: 'small',
								value:'Small',
							},
							{ 
								key: 'medium',
								value:'Medium',
							},
							{ 
								key: 'large',
								value:'Large',
							},
						]
					},
					{
						type: 'text',
						name: 'Default Value',
					},
					{
						type: 'select',
						name: 'Required',
						options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
						]
					},
					{
						type: 'text',
						name: 'CSS Classes',
					},
					{
						type : 'text',
						name : 'API Parameter',
					},
			]
		
	},
	password : {
		fields:
			[
				{
					type: 'text',
					name: 'Name',
				},
				{
					name: 'Description',
					type: 'textarea',
				},
				{
					type: 'select',
					name: 'Size',
					options: [
						{
							key: 'small',
							value: 'Small',
						},
						{
							key: 'medium',
							value: 'Medium',
						},
						{
							key: 'large',
							value: 'Large',
						},
					]
				},
				{
					type: 'text',
					name: 'Default Value',
				},
				{
					type: 'select',
					name: 'Required',
					options: [
						{
							key: 'no',
							value: 'No',
						},
						{
							key: 'yes',
							value: 'Yes',
						},
					]
				},
				{
					type: 'text',
					name: 'CSS Classes',
				},
				{
					type: 'text',
					name: 'API Parameter',
				},
			]
	},
		textarea : {
		fields: 
			[
					{
						type : 'text',
						name : 'Name',
					},
					{
						name: 'Description',
						type: 'textarea',
					},
					{
						type: 'select',
						name: 'Size',
						options: [
							{ 
								key: 'small',
								value:'Small',
							},
							{ 
								key: 'medium',
								value:'Medium',
							},
							{ 
								key: 'large',
								value:'Large',
							},
						]
					},
					{
						type: 'text',
						name: 'Default Value',
					},
					{
						type: 'select',
						name: 'Required',
						options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
						]
					},					
					{
						type: 'text',
						name: 'CSS Classes',
					},
					{
						type : 'text',
						name : 'API Parameter',
					},
			]
		
	},
	checkbox : {
		fields: 
			[
					{
						type : 'text',
						name : 'Name',
					},
					{
						name: 'Description',
						type: 'textarea',
					},
					{
						type: 'options',
						name: 'Options',
					},
					{
						type: 'select',
						name: 'Required',
						options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
						]
					},
					{
						type: 'text',
						name: 'Default Value',
					},
					{
						type: 'text',
						name: 'CSS Classes',
					},
					{
						type : 'text',
						name : 'API Parameter',
					},
			]
		
	},
	radio : {
		fields: 
			[
					{
						type : 'text',
						name : 'Name',
					},
					{
						name: 'Description',
						type: 'textarea',
					},
					{
						type: 'options',
						name: 'Options',
					},
					{
						type: 'select',
						name: 'Required',
						options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
						]
					},
					{
						type: 'text',
						name: 'Default Value',
					},
					{
						type: 'text',
						name: 'CSS Classes',
					},
					{
						type : 'text',
						name : 'API Parameter',
					},
			]
		
	},
	select : {
		fields: 
			[
					{
						type : 'text',
						name : 'Name',
					},
					{
						name: 'Description',
						type: 'textarea',
					},
					{
						type: 'options',
						name: 'Options',
					},
					{
						type: 'text',
						name: 'Default Value',
					},
					{
						type: 'select',
						name: 'Required',
						options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
						]
					},
					{
						type: 'text',
						name: 'CSS Classes',
					},
					{
						type : 'text',
						name : 'API Parameter',
					},
			]
		
	},
	email : {
		fields: 
			[
					{
						type : 'text',
						name : 'Name',
					},
					{
						name: 'Description',
						type: 'textarea',
					},
					{
						type: 'select',
						name: 'Size',
						options: [
							{ 
								key: 'small',
								value:'Small',
							},
							{ 
								key: 'medium',
								value:'Medium',
							},
							{ 
								key: 'large',
								value:'Large',
							},
						]
					},
					{
						type: 'text',
						name: 'Default Value',
					},
					{
						type: 'select',
						name: 'Required',
						options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
						]
					},
					{
						type: 'text',
						name: 'CSS Classes',
					},
					{
						type : 'text',
						name : 'API Parameter',
					},
			]
		
	},
	signature : {
		fields:
			[
				{
					type : 'text',
					name : 'Name',
				},
				{
					name: 'Description',
					type: 'textarea',
				},
				{
					type: 'select',
					name: 'Size',
					options: [
						{
							key: 'small',
							value:'Small',
						},
						{
							key: 'medium',
							value:'Medium',
						},
						{
							key: 'large',
							value:'Large',
						},
					]
				},
				{
					type: 'text',
					name: 'Default Value',
				},
				{
					type: 'select',
					name: 'Required',
					options: [
						{
							key: 'no',
							value:'No',
						},
						{
							key: 'yes',
							value:'Yes',
						},
					]
				},
				{
					type: 'text',
					name: 'CSS Classes',
				},
				{
					type : 'text',
					name : 'API Parameter',
				},
			]

	},
	date : {
		fields: 
			[
					{
						type : 'text',
						name : 'Name',
					},
					{
						type: 'select',
						name: 'Size',
						options: [
							{
								key: 'small',
								value:'Small',
							},
							{
								key: 'medium',
								value:'Medium',
							},
							{
								key: 'large',
								value:'Large',
							},
						]
					},
					{
						type: 'select',
						name: 'Date format',
						options: [
							{ 
								key: 'mm/dd/yy',
								value:'mm/dd/yy',
							},
							{
								key: 'dd/mm/yy',
								value:'dd/mm/yy',
							},
							{ 
								key: 'yy-mm-dd',
								value:'yy-mm-dd',
							},
							{ 
								key: 'd M, y',
								value:'d MM, y',
							},
							{ 
								key: 'DD, d MM, yy',
								value:'DD, d MM, yy',
							},

						]
					},
					{
						name: 'Description',
						type: 'textarea',
					},
					{
						type: 'text',
						name: 'Default Value',
					},
					{
						type: 'select',
						name: 'Required',
						options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
						]
					},
					{
						type: 'text',
						name: 'CSS Classes',
					},
					{
						type : 'text',
						name : 'API Parameter',
					},
			]
		
	},
	currency : {
		fields: 
			[
					{
						type : 'text',
						name : 'Name',
					},
					{
						name: 'Description',
						type: 'textarea',
					},
					{
						type: 'select',
						name: 'Size',
						options: [
							{ 
								key: 'small',
								value:'Small',
							},
							{ 
								key: 'medium',
								value:'Medium',
							},
							{ 
								key: 'large',
								value:'Large',
							},
						]
					},
					{
						type: 'text',
						name: 'Default Value',
					},
					{
						type: 'select',
						name: 'Required',
						options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
						]
					},
					{
						type: 'text',
						name: 'CSS Classes',
					},
					{
						type : 'text',
						name : 'API Parameter',
					},
			]
		
	},
	url: {
		fields: 
			[
					{
						type : 'text',
						name : 'Name',
					},
					{
						name: 'Description',
						type: 'textarea',
					},
					{
						type: 'select',
						name: 'Size',
						options: [
							{ 
								key: 'small',
								value:'Small',
							},
							{ 
								key: 'medium',
								value:'Medium',
							},
							{ 
								key: 'large',
								value:'Large',
							},
						]
					},
					{
						type: 'text',
						name: 'Default Value',
					},
					{
						type: 'select',
						name: 'Required',
						options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
						]
					},
					{
						type: 'text',
						name: 'CSS Classes',
					},
					{
						type : 'text',
						name : 'API Parameter',
					},
			]
		
	},
	phone : {
		fields: 
			[
				{
					type : 'text',
					name : 'Name',
				},
				{
					name: 'Description',
					type: 'textarea',
				},
				{
					type: 'select',
					name: 'Size',
					options: [
						{ 
							key: 'small',
							value:'Small',
						},
						{ 
							key: 'medium',
							value:'Medium',
						},
						{ 
							key: 'large',
							value:'Large',
						},
					]
				},
				{
					type: 'text',
					name: 'Default Value',
				},
				{
					type: 'select',
					name: 'Required',
					options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
					]
				},
				{
					type: 'text',
					name: 'CSS Classes',
				},
				{
					type : 'text',
					name : 'API Parameter',
				},
			]
		
	},
	number : {
		fields: 
			[
				{
					type : 'text',
					name : 'Name',
				},
				{
					name: 'Description',
					type: 'textarea',
				},
				{
					type: 'select',
					name: 'Size',
					options: [
						{ 
							key: 'small',
							value:'Small',
						},
						{ 
							key: 'medium',
							value:'Medium',
						},
						{ 
							key: 'large',
							value:'Large',
						},
					]
				},
				{
					type: 'text',
					name: 'Default Value',
				},
				{
					type: 'select',
					name: 'Required',
					options: [
							{ 
								key: 'no',
								value:'No',
							},
							{ 
								key: 'yes',
								value:'Yes',
							},
					]
				},
				{
					type: 'text',
					name: 'CSS Classes',
				},
				{
					type : 'text',
					name : 'API Parameter',
				},
			]
		
	},
	instructions : {
		fields: 
			[
				{
					type : 'text',
					name : 'Name',
				},
				{
					name: 'Instructions (HTML tags allowed)',
					type: 'textarea',
				},
				{
					type: 'text',
					name: 'CSS Classes',
				},
			]
		
	},
	ccform : {
		fields: 
			[
				{
					type : 'text',
					name : 'Name',
				},
				{
					name: 'Description',
					type: 'textarea',
				},
				{
					type : 'text',
					name : 'CCard number API Parameter',
				},
				{
					type : 'text',
					name : 'CCard expiry date API Parameter',
				},
				{
					type : 'text',
					name : 'CCard CVC code API Parameter',
				},
			]
		
	},
    time : {
        fields:
            [
                {
                    type : 'text',
                    name : 'Name',
                },
                {
                    name: 'Description',
                    type: 'textarea',
                },
                {
                    type: 'select',
                    name: 'Size',
                    options: [
                        {
                            key: 'small',
                            value:'Small',
                        },
                        {
                            key: 'medium',
                            value:'Medium',
                        },
                        {
                            key: 'large',
                            value:'Large',
                        },
                    ]
                },
                {
                    type: 'time',
                    name: 'Default Value',
                },
                {
                    type: 'select',
                    name: 'Required',
                    options: [
                        {
                            key: 'no',
                            value:'No',
                        },
                        {
                            key: 'yes',
                            value:'Yes',
                        },
                    ]
                },
                {
                    type: 'text',
                    name: 'CSS Classes',
                },
                {
                    type : 'text',
                    name : 'API Parameter',
                },
            ]

    },
};


// ucfirst alternative
String.prototype.capitalize = function() {
    return this.charAt(0).toUpperCase() + this.slice(1);
}


jQuery(function() {
	jQuery('.draggable-form-item').click(function(e){
		//var current_field =	++fields_counter; 
		var current_field =	fields_counter + 1;
		fields_counter++; 
		e.preventDefault();
		var field_type = jQuery(this).attr('data-type');
		if( ["ccform","url"].indexOf(field_type) != -1 ){
			var field_title = field_type.toUpperCase();
		}else{
			var field_title = field_type.capitalize();
		}
	    var html_form = '';
	    jQuery.each(wc_custom_payment_fields_meta[field_type].fields, function(key, item){
	    	var field_name = 'field_'+ field_type + '_' + item.name.split(' ').join('-').toLowerCase() + '_' + item.type +'_'+ current_field;
	    	switch(  item.type ){
	    		case 'text':
	    			html_form += '<p class="description description-wide"><label>'+ item.name +'<br/><input class="widefat code" type="text" name="'+	field_name	+'" /></label></p>';
	    		break;
                case 'time':
                    html_form += '<p class="description description-wide"><label>'+ item.name +'<br/><input class="widefat code" type="time" name="'+	field_name	+'" /></label></p>';
                    break;
	    		case 'textarea':
	    			html_form += '<p class="description description-wide"><label>'+ item.name +'<br/><textarea class="widefat code" name="'+	field_name	+'"></textarea></label></p>';
	    		break;
	    		case 'select':
	    			var options = '';
	    			var selected = '';
	    			jQuery.each(item.options,function(i, option){
	    				var selected = (option.key == 'medium')?'selected':'';
	    				options += '<option '+selected+' value="'+ option.key +'">'+ option.value +'</option>';
	    			});
	    			html_form += '<p class="description description-thin"><label>'+ item.name +'<br/><select class="widefat code" name="'+	field_name	+'">' + options + '</label></select></p>';
	    		break;

	    		case 'options':
	    			html_form += '<p class="description description-wide"<label>'+ item.name +'<br/>';
	    			html_form += '<ul class="field_options" id="'+ field_name + '">';
	    				html_form += '<li><input name="'+ field_name +'[]" class="code" value="Option 1" type="text" /><span class="delete_option dashicons dashicons-trash"></span><span class="dashicons  dashicons-menu"></span></li>';
	    				html_form += '<li><input name="'+ field_name +'[]" class="code" value="Option 2" type="text" /><span class="delete_option dashicons dashicons-trash"></span><span class="dashicons  dashicons-menu"></span></li>';
	    				html_form += '<li><input name="'+ field_name +'[]" class="code" value="Option 3" type="text" /><span class="delete_option dashicons dashicons-trash"></span><span class="dashicons  dashicons-menu"></span></li>';
	    			html_form += '</ul>';
	    			html_form += '<a class="add-option-btn button-secondary" data-field="'+field_name+'" href="javascript:void(0)"><span class="dashicons dashicons-plus-alt"></span>Add Option</a>';
	    			html_form += '</label></p>';
	    		break;
	    	}
	    });
	    var new_element =	'<li id="field_'+ current_field +'" class="group '+	field_type	+'">'+
							    '<h3>'+ field_title +' <div class="controls"><label>'+ field_type.capitalize() +'</label> <a href="javascript:void(0)" class="delete_field_from_header"><span class="dashicons dashicons-trash"></span></a> </div></h3>'+
							    '<div class="form_details">'+ html_form +
							    '<a href="javascript:void(0)" class="delete_field"><span class="dashicons dashicons-trash"></span> Delete</a></div>'+
							'</li>';
    	jQuery('#fields_wrap').append(new_element);
    	jQuery( "#fields_wrap" ).accordion( "refresh" );
    	jQuery('.field_options').sortable();

    	jQuery('.add-option-btn').click(function(e){
    		e.preventDefault();
    		jQuery('#'+ jQuery(this).attr('data-field')).append('<li><input name="'+ jQuery(this).attr('data-field') +'[]" class="code" value="" type="text" /><span class="delete_option dashicons dashicons-trash"></span><span class="dashicons  dashicons-menu"></span></li>');
    		jQuery( "#fields_wrap" ).accordion( "refresh" );
    		jQuery('.field_options').sortable();
	    	jQuery('.delete_option').click(function(e){
		    	e.preventDefault();
		    	jQuery(this).parent().remove();
		    });    		
    	});
    	jQuery('.delete_option').click(function(e){
    		e.preventDefault();
    		jQuery(this).parent().remove();
    	});
    	jQuery('.delete_field').click(function(e){
    		e.preventDefault();
    		jQuery(this).parent().parent().remove();
    	});
        jQuery('.delete_field_from_header').click(function(e){
    		e.preventDefault();
    		jQuery(this).parent().parent().parent().remove();
   		});

	});

    jQuery('.add-option-btn').click(function(e){
    	e.preventDefault();
    	jQuery('#'+ jQuery(this).attr('data-field')).append('<li><input name="'+ jQuery(this).attr('data-field') +'[]" class="code" value="" type="text" /><span class="delete_option dashicons dashicons-trash"></span><span class="dashicons  dashicons-menu"></span></li>');
    	jQuery( "#fields_wrap" ).accordion( "refresh" );
    	jQuery('.field_options').sortable();
    	jQuery('.delete_option').click(function(e){
	    	e.preventDefault();
	    	jQuery(this).parent().remove();
	    });
    });
    jQuery('.delete_option').click(function(e){
    	e.preventDefault();
    	jQuery(this).parent().remove();
    });
    jQuery('.delete_field').click(function(e){
    	e.preventDefault();
    	jQuery(this).parent().parent().remove();
    });
    jQuery('.delete_field_from_header').click(function(e){
    	e.preventDefault();
    	jQuery(this).parent().parent().parent().remove();
    });



    jQuery('.field_options').sortable();


    // :START The accordion code for the form elements
		    var icons = {
		      header: "ui-icon-circle-arrow-w",
		      activeHeader: "ui-icon-circle-arrow-s"
		    };
		     jQuery( "#fields_wrap" )
		      .accordion({
		        header: "> li > h3",
		        collapsible: true,
		        active: false, 
		        heightStyle: "content",
		        icons: icons,
		      })
		      .sortable({
		        axis: "y",
		        handle: "h3",
		        placeholder: "ui-state-highlight",
		        stop: function( event, ui ) {
		          // IE doesn't register the blur when sorting
		          // so trigger focusout handlers to remove .ui-state-focus
		          ui.item.children( "h3" ).triggerHandler( "focusout" );
		 
		          // Refresh accordion to handle new order
		          jQuery( this ).accordion( "refresh" );
		        }
		      });
    // :END



    // Extra API Atts
    jQuery('#add_row_extra_atts_button').click(function(e){
    	e.preventDefault();
		var row = '<tr>'+
						'<td><input name="extra_keys[]" class="widefat" type="text"></td>'+
						'<td><input name="extra_values[]" class="widefat" type="text"></td>'+
						'<td><a class="delete_api_key" href="javascript:void(0);"><span class="dashicons  dashicons-trash"></span></a></td>'+
					'</tr>';
    	jQuery('#customized_payment_extra_attrs tbody').append(row);
    	// activate the deletion.
        jQuery('.delete_api_key').click(function(e){
    		jQuery(this).parent().parent().remove();
    	});
    });
    // Extra API Atts
    jQuery('#add_row_wc_atts_button').click(function(e){
    	e.preventDefault();
		var row = '<tr>'+
						'<td><input name="wc_keys[]" class="widefat" type="text"></td>'+
						'<td><select name="wc_values[]">'+
												'<option value="order_id">Order ID</option>'+
												'<option value="order_total">Order Total</option>'+
												'<option value="customer_id">Customer ID</option>'+
												'<option value="billing_first_name">Customer First Name</option>'+
												'<option value="billing_last_name">Customer Last Name</option>'+
												'<option value="billing_postcode">Customer Postcode</option>'+
												'<option value="billing_address_1">Customer Address line 1</option>'+
												'<option value="billing_address_1">Customer Address line 2</option>'+
												'<option value="billing_city">Customer City</option>'+
												'<option value="billing_state">Customer State</option>'+
												'<option value="billing_country">Customer Country</option>'+
												'<option value="billing_email">Customer Email</option>'+
												'<option value="billing_phone">Customer Phone</option>'+
												'<option value="billing_ip_address">Customer IP Address</option>'+
												'<option value="return_url">Order Return URL</option>'+
											'</select></td>'+
						'<td><a class="delete_api_key" href="javascript:void(0);"><span class="dashicons  dashicons-trash"></span></a></td>'+
					'</tr>';
    	jQuery('#customized_payment_wc_attrs tbody').append(row);
    	// activate the deletion.
        jQuery('.delete_api_key').click(function(e){
    		jQuery(this).parent().parent().remove();
    	});
    });
    jQuery('.delete_api_key').click(function(e){
    	jQuery(this).parent().parent().remove();
    });



});