<?php

if ( !defined( 'ABSPATH' ) ) exit;

if ( ! class_exists( 'Smart_Manager_Pro_Shop_Coupon' ) ) {
	class Smart_Manager_Pro_Shop_Coupon extends Smart_Manager_Pro_Base {
		public $dashboard_key = '',
				$plugin_path = '';

		protected static $_instance = null;
		public $shop_coupon = '';


		public static function instance($dashboard_key) {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self($dashboard_key);
			}
			return self::$_instance;
		}

		function __construct($dashboard_key) {
			parent::__construct($dashboard_key);

			$this->plugin_path  = untrailingslashit( plugin_dir_path( __FILE__ ) );

			if ( file_exists(SM_BETA_URL . 'classes/class-smart-manager-shop-coupon.php') ) {
				include_once SM_BETA_URL . 'classes/class-smart-manager-shop-coupon.php';
				$this->shop_coupon = new Smart_Manager_Shop_Coupon( $dashboard_key );
			}
		}

		public static function actions() {

		}

		public function __call( $function_name, $arguments = array() ) {

			if( empty( $this->shop_coupon ) ) {
				return;
			}

			if ( ! is_callable( array( $this->shop_coupon, $function_name ) ) ) {
				return;
			}

			if ( ! empty( $arguments ) ) {
				return call_user_func_array( array( $this->shop_coupon, $function_name ), $arguments );
			} else {
				return call_user_func( array( $this->shop_coupon, $function_name ) );
			}
		}


	}

}