<?php
/**
 * Payment Gateway Currency for WooCommerce - Convert Section Settings
 *
 * @version 1.5.0
 * @since   1.4.0
 *
 * @author  Algoritmika Ltd.
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

if ( ! class_exists( 'Alg_WC_Payment_Gateways_by_Currency_Settings_Convert' ) ) :

class Alg_WC_Payment_Gateways_by_Currency_Settings_Convert extends Alg_WC_Payment_Gateways_by_Currency_Settings_Section {

	/**
	 * Constructor.
	 *
	 * @version 1.4.0
	 * @since   1.4.0
	 */
	function __construct() {
		$this->id   = 'convert';
		$this->desc = __( 'Convert Currency', 'payment-gateways-by-currency-for-woocommerce' );
		parent::__construct();
	}

	/**
	 * get_settings.
	 *
	 * @version 1.5.0
	 * @since   1.4.0
	 *
	 * @todo    [next] (desc) `auto_rates`: better desc
	 * @todo    [next] (feature) `auto_rates`: add more servers
	 * @todo    [next] (feature) `auto_rates`: offset (fixed, percent)
	 * @todo    [later] Currency symbol: make optional (i.e. add "Set currency symbol" checkbox)?
	 * @todo    [later] `alg_wc_pgbc_convert_currency_enabled`: better desc?
	 * @todo    [maybe] merge with `Alg_WC_Payment_Gateways_by_Currency_Settings_General::get_settings()`?
	 */
	function get_settings() {

		$main_settings = array(
			array(
				'title'    => __( 'Convert Currency Options', 'payment-gateways-by-currency-for-woocommerce' ),
				'type'     => 'title',
				'id'       => 'alg_wc_pgbc_convert_currency_options',
			),
			array(
				'title'    => __( 'Convert currency', 'payment-gateways-by-currency-for-woocommerce' ),
				'desc'     => '<strong>' . __( 'Enable section', 'payment-gateways-by-currency-for-woocommerce' ) . '</strong>',
				'desc_tip' => __( 'Convert cart currencies and prices by the currency exchange rates.', 'payment-gateways-by-currency-for-woocommerce' ),
				'id'       => 'alg_wc_pgbc_convert_currency_enabled',
				'default'  => 'no',
				'type'     => 'checkbox',
			),
			array(
				'type'     => 'sectionend',
				'id'       => 'alg_wc_pgbc_convert_currency_options',
			),
		);

		$currencies         = get_woocommerce_currencies();
		$convert_currencies = get_option( 'alg_wc_pgbc_convert_currency', array() );
		$paypal_tip         = $this->get_paypal_tip( $currencies, false );
		$gateways           = WC()->payment_gateways->payment_gateways();
		$gateways_settings  = array();
		foreach ( $gateways as $key => $gateway ) {
			$gateways_settings = array_merge( $gateways_settings, array(
				array(
					'title'    => ( ! empty( $gateway->method_title ) ? $gateway->method_title : ( ! empty( $gateway->title ) ? $gateway->title : $key ) ),
					'desc'     => ( ! in_array( $key, array( 'bacs', 'cheque', 'paypal', 'cod' ) ) ? apply_filters( 'alg_wc_pgbc_settings', $this->get_pro_desc() ) : '' ),
					'type'     => 'title',
					'id'       => 'alg_wc_pgbc_convert_currency_' . $key,
				),
				array(
					'title'    => __( 'Convert currency', 'payment-gateways-by-currency-for-woocommerce' ),
					'desc_tip' => ( 'paypal' == $key ? $paypal_tip : '' ),
					'id'       => "alg_wc_pgbc_convert_currency[{$key}]",
					'default'  => '',
					'type'     => 'select',
					'class'    => 'chosen_select',
					'options'  => array_merge( array( '' => __( 'Do not convert', 'payment-gateways-by-currency-for-woocommerce' ) ), $currencies ),
					'custom_attributes' => ( ! in_array( $key, array( 'bacs', 'cheque', 'paypal', 'cod' ) ) ? apply_filters( 'alg_wc_pgbc_settings', array( 'disabled' => 'disabled' ) ) : '' ),
				),
				array(
					'title'    => __( 'Conversion rate', 'payment-gateways-by-currency-for-woocommerce' ),
					'desc_tip' => ( isset( $convert_currencies[ $key ] ) && '' !== $convert_currencies[ $key ] ? get_woocommerce_currency() . $convert_currencies[ $key ] : '' ),
					'id'       => "alg_wc_pgbc_convert_rate[{$key}]",
					'default'  => '',
					'type'     => 'number',
					'custom_attributes' => ( ! in_array( $key, array( 'bacs', 'cheque', 'paypal', 'cod' ) ) ? apply_filters( 'alg_wc_pgbc_settings', array( 'readonly' => 'readonly' ), 'price' ) : array( 'step' => 0.000001 ) ),
				),
				array(
					'title'    => __( 'Currency symbol', 'payment-gateways-by-currency-for-woocommerce' ),
					'desc_tip' => ( isset( $convert_currencies[ $key ] ) && '' !== $convert_currencies[ $key ] ?
						sprintf( __( 'Leave empty for the default symbol (%s).', 'payment-gateways-by-currency-for-woocommerce' ), get_woocommerce_currency_symbol( $convert_currencies[ $key ] ) ) : '' ),
					'id'       => "alg_wc_pgbc_convert_symbol[{$key}]",
					'default'  => '',
					'type'     => 'text',
					'custom_attributes' => ( ! in_array( $key, array( 'bacs', 'cheque', 'paypal', 'cod' ) ) ? apply_filters( 'alg_wc_pgbc_settings', array( 'readonly' => 'readonly' ) ) : '' ),
				),
				array(
					'type'     => 'sectionend',
					'id'       => 'alg_wc_pgbc_convert_currency_' . $key,
				),
			) );
		}

		$next_scheduled = false;
		if ( '' != get_option( 'alg_wc_pgbc_convert_currency_auto_rates_cron', '' ) ) {
			$next_scheduled = wp_next_scheduled( 'alg_wc_pgbc_currency_exchange_rates', array( 'hourly' ) );
		}
		$auto_rates_settings = array(
			array(
				'title'    => __( 'Automatic Currency Exchange Rates Options', 'payment-gateways-by-currency-for-woocommerce' ),
				'desc'     => sprintf( __( 'This section allows you to automatically update currency exchange rates from the %s server.', 'payment-gateways-by-currency-for-woocommerce' ),
					'<a href="https://www.ecb.europa.eu/stats/policy_and_exchange_rates/euro_reference_exchange_rates/html/index.en.html" target="_blank">' .
						__( 'European Central Bank (ECB)', 'payment-gateways-by-currency-for-woocommerce' ) . '</a>' ),
				'type'     => 'title',
				'id'       => 'alg_wc_pgbc_convert_currency_auto_rates_options',
			),
			array(
				'title'    => __( 'Update periodically', 'payment-gateways-by-currency-for-woocommerce' ),
				'desc'     => ( $next_scheduled ? sprintf( __( 'Next update is scheduled on %s.', 'payment-gateways-by-currency-for-woocommerce' ),
					'<code>' . date_i18n( 'Y-m-d H:i:s', $next_scheduled + ( int ) ( get_option( 'gmt_offset' ) * HOUR_IN_SECONDS ) ) . '</code>' ) : '' ),
				'id'       => 'alg_wc_pgbc_convert_currency_auto_rates_cron',
				'default'  => '',
				'type'     => 'select',
				'class'    => 'chosen_select',
				'options'  => array(
					''           => __( 'Disabled', 'payment-gateways-by-currency-for-woocommerce' ),
					'hourly'     => __( 'Update hourly', 'payment-gateways-by-currency-for-woocommerce' ),
				),
			),
			array(
				'title'    => __( 'Update now', 'payment-gateways-by-currency-for-woocommerce' ),
				'desc'     => __( 'Update all rates now', 'payment-gateways-by-currency-for-woocommerce' ),
				'desc_tip' => __( 'Check the box and save changes to update.', 'payment-gateways-by-currency-for-woocommerce' ),
				'id'       => 'alg_wc_pgbc_convert_currency_auto_rates_now',
				'default'  => 'no',
				'type'     => 'checkbox',
			),
			array(
				'type'     => 'sectionend',
				'id'       => 'alg_wc_pgbc_convert_currency_auto_rates_options',
			),
		);

		$advanced_settings = array(
			array(
				'title'    => __( 'Advanced Options', 'payment-gateways-by-currency-for-woocommerce' ),
				'type'     => 'title',
				'id'       => 'alg_wc_pgbc_convert_currency_advanced_options',
			),
			array(
				'title'    => __( 'Convert', 'payment-gateways-by-currency-for-woocommerce' ),
				'desc'     => __( 'Shipping price', 'payment-gateways-by-currency-for-woocommerce' ),
				'id'       => 'alg_wc_pgbc_convert_currency_advanced[shipping]',
				'default'  => 'yes',
				'type'     => 'checkbox',
				'checkboxgroup' => 'start',
			),
			array(
				'desc'     => __( 'Coupon amounts ("Fixed cart/product discount" coupons only)', 'payment-gateways-by-currency-for-woocommerce' ),
				'id'       => 'alg_wc_pgbc_convert_currency_advanced[coupon]',
				'default'  => 'yes',
				'type'     => 'checkbox',
				'checkboxgroup' => '',
			),
			array(
				'desc'     => __( 'Coupon minimum spend', 'payment-gateways-by-currency-for-woocommerce' ),
				'id'       => 'alg_wc_pgbc_convert_currency_advanced[coupon_min_amount]',
				'default'  => 'yes',
				'type'     => 'checkbox',
				'checkboxgroup' => '',
			),
			array(
				'desc'     => __( 'Coupon maximum spend', 'payment-gateways-by-currency-for-woocommerce' ),
				'id'       => 'alg_wc_pgbc_convert_currency_advanced[coupon_max_amount]',
				'default'  => 'yes',
				'type'     => 'checkbox',
				'checkboxgroup' => '',
			),
			array(
				'desc'     => __( 'Cart fees', 'payment-gateways-by-currency-for-woocommerce' ),
				'id'       => 'alg_wc_pgbc_convert_currency_advanced[cart_fee]',
				'default'  => 'no',
				'type'     => 'checkbox',
				'checkboxgroup' => 'end',
			),
			array(
				'type'     => 'sectionend',
				'id'       => 'alg_wc_pgbc_convert_currency_advanced_options',
			),
		);

		return array_merge( $main_settings, $gateways_settings, $auto_rates_settings, $advanced_settings );
	}

}

endif;

return new Alg_WC_Payment_Gateways_by_Currency_Settings_Convert();
