<?php
/**
* Getting Started
* 
* @package cf7skins
* @author Neil Murray
* @since 1.2
*/
?>
<div class="cf7s-info">
<h2><?php _e( 'Quick Start Guide', CF7SKINS_TEXTDOMAIN ); ?></h2>

<p><?php _e( 'To get started using <strong>CF7 Skins</strong>:', CF7SKINS_TEXTDOMAIN ); ?></p>

<ul>
	<li>
		<?php _e( 'Click on <strong>Contact</strong> in the WordPress admin menu.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
		<?php _e( 'Select an existing Contact Form 7 form or create a new one.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
		<?php _e( 'Scroll down to the <strong>Skins</strong> section.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<h3><?php _e( 'Using CF7 Skins', CF7SKINS_TEXTDOMAIN ); ?></h3>

<p>1. <a href="http://cf7skins.com/visual-editor/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started" target="_blank"><strong><?php _ex('CF7 Skins','Stand-alone form. No conjugations needed.',CF7SKINS_TEXTDOMAIN); ?><?php _e( ' Visual Editor', CF7SKINS_TEXTDOMAIN ); ?></strong></a><?php _e( ' – where you edit and build your form.', CF7SKINS_TEXTDOMAIN ); ?></p>

<p><img src="<?php echo CF7SKINS_URL; ?>images/cf7skins-visual-ui.png" alt="CF7 Skins Visual Editor UI" width="600" height="449" class="alignright" /><em><?php _e( 'Start with a CF7 Skins Template.', CF7SKINS_TEXTDOMAIN ); ?> </em></p>

<ul>
	<li>
		<?php _e( 'Select a <strong>Template</strong> to add it to the <strong>Form</strong> tab.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
		<?php _e( 'The <strong>Form</strong> tab is where you build your form.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<p><em><?php _e( 'Add fields and arrange them using drag and drop.', CF7SKINS_TEXTDOMAIN ); ?> </em></p>

<ul>
	<li>
		<?php _e( '<strong>Drag-and-drop</strong> new fields onto your form.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
		<?php _e( 'Rearrange fields into the correct position.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<p><em><?php _e( 'Edit the form to match your requirements.', CF7SKINS_TEXTDOMAIN ); ?> </em></p>

<ul>
	<li>
		<?php _e( 'Click <strong>Edit</strong>, <strong>Duplicate</strong> & <strong>Delete</strong> to adjust fields.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
		<?php _e( 'Add <strong>CF7 Tag</strong> options in the <strong>Edit</strong> dialog.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<p><em><?php _e( 'Review & save your Form.', CF7SKINS_TEXTDOMAIN ); ?> </em></p>

<ul>
	<li>
		<?php _e( '<strong>Duplicate</strong> groups of fields to speed form creation.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
		<?php _e( 'Click <strong>Save Visual</strong> - your changes are added in the <strong>CF7 Form</strong> tab.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<p><a class="cf7s-btn" target="_blank" href="http://kb.cf7skins.com/category/visual-editor/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"><?php _e( 'Learn More', CF7SKINS_TEXTDOMAIN ); ?></a></p>

<div class="wp-clearfix"></div>

<p>2. <a href="http://cf7skins.com/templates/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><strong><?php _e( ' Templates', CF7SKINS_TEXTDOMAIN ); ?></strong></a><?php _e( ' – give you a starting point for your form.', CF7SKINS_TEXTDOMAIN ); ?></p>


<p><img src="<?php echo CF7SKINS_URL; ?>images/cf7skins-templates.png" alt="CF7 Skins Templates" width="600" height="238" class="alignright" /><em><?php _e( 'Each <strong>Template</strong> acts as an easy to follow guide, which can be adapted to your particular requirements.', CF7SKINS_TEXTDOMAIN ); ?></em></p>

<ul>
	<li>
		<?php _e( 'The <strong>Template</strong> tab displays the available templates.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
		<?php _e( 'Click <strong>Select</strong> to add this template in the <strong>Form</strong> tab.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
		<?php _e( 'Then use the <strong>Visual Editor</strong> to adjust the form to your requirements.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<p><a class="cf7s-btn" target="_blank" href="http://kb.cf7skins.com/category/templates/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"><?php _e( 'Learn More', CF7SKINS_TEXTDOMAIN ); ?></a></p>

<div class="wp-clearfix"></div>

<p>3. <a href="http://cf7skins.com/styles/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started" target="_blank"><strong><?php _e( ' Styles', CF7SKINS_TEXTDOMAIN ); ?></strong></a><?php _e( ' – control the appearance for your form.', CF7SKINS_TEXTDOMAIN ); ?></p>

<p><img src="<?php echo CF7SKINS_URL; ?>images/cf7skins-styles.png" alt="CF7 Skins Styles" width="600" height="239" class="alignright" /><em><?php _e( 'Every <strong>Style</strong> covers the full range of Contact Form 7 form elements.', CF7SKINS_TEXTDOMAIN ); ?></em></p>

<ul>
	<li>
		<?php _e( 'View the <strong>Style</strong> tab to see the available styles.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
		<?php _e( 'Find a style you like and click <strong>Select</strong>.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
		<li>
		<?php _e( 'Then press <strong>Save</strong> or <strong>Save Visual</strong> to apply the style to your form.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<p><a class="cf7s-btn" target="_blank" href="http://kb.cf7skins.com/category/styles/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"><?php _e( 'Learn More', CF7SKINS_TEXTDOMAIN ); ?></a></p>

<div class="wp-clearfix"></div>

<h3><?php _e( 'Doing more with CF7 Skins', CF7SKINS_TEXTDOMAIN ); ?></h3>
<p><?php _e( 'To take advantage of the full functionality of CF7 Skins we recommend reading the following items.', CF7SKINS_TEXTDOMAIN ); ?></p>

<ul>
	<li>
	<a href="http://kb.cf7skins.com/getting-started-using-cf7-skins/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Getting Started – Using CF7 Skins', CF7SKINS_TEXTDOMAIN ); ?></a>
	</li>
	<li>
	<a href="http://kb.cf7skins.com/edit-cf7-skins-form-visual-editor/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Edit your CF7 Skins Form', CF7SKINS_TEXTDOMAIN ); ?></a>
	</li>
	<li>
	<a href="http://kb.cf7skins.com/why-we-use-fieldset-legend-lists-in-cf7-skins/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Fieldset, Legend & Lists in CF7 Skins', CF7SKINS_TEXTDOMAIN ); ?></a>
	</li>
	<li>
	<a href="http://kb.cf7skins.com/use-custom-css-plugin/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Modify your CF7 Skins Style', CF7SKINS_TEXTDOMAIN ); ?></a>
	</li>
</ul>

<p><a class="cf7s-btn" target="_blank" href="http://kb.cf7skins.com/category/using-cf7skins/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"><?php _e( 'Learn More', CF7SKINS_TEXTDOMAIN ); ?></a></p>

</div>

<div class="cf7s-info-sidebar">
<h2><?php _e( 'Do you enjoy using this plugin?', CF7SKINS_TEXTDOMAIN ); ?></h2>
<p><?php _e( 'You can help fellow WordPress users in the following simple ways', CF7SKINS_TEXTDOMAIN ); ?></p>
<ul>
	<li>
	<strong><a href="https://wordpress.org/support/plugin/contact-form-7-skins/reviews/#new-post"  target="_blank"><?php _e( 'Review', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'leave a  plugin review on WordPress.org', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://cf7skins.com/testimonials/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Testimonial', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'add your Testimonial to those listed', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://cf7skins.com/support/#feedback?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Feedback', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'help us to improve CF7 Skins by offering feedback', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<h2><?php _e( 'Documentation', CF7SKINS_TEXTDOMAIN ); ?></h2>
<p><?php _e( 'Our in-depth documentation is a great place to find detailed answers', CF7SKINS_TEXTDOMAIN ); ?></p>
<ul>
	<li>
	<strong><a href="http://kb.cf7skins.com/faq/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'FAQ', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'browse over some commonly asked questions.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://kb.cf7skins.com/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Documentation', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'search by Categories & Tags or Keywords.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://kb.cf7skins.com/category/tutorials/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Tutorials', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'to help you get started quickly with CF7 Skins.', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<h2><?php _e( 'Need some help?', CF7SKINS_TEXTDOMAIN ); ?></h2>
<p><?php _e( 'You have a number of options to help you use CF7 Skins', CF7SKINS_TEXTDOMAIN ); ?></p>
<ul>
	<li><strong><?php _e( 'Free Version', CF7SKINS_TEXTDOMAIN ); ?></strong></li>
	<ul>
		<li>
		<strong><a href="https://wordpress.org/support/plugin/contact-form-7-skins"  target="_blank"><?php _e( 'WordPress.org Support Forum', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'community based support offered by other CF7 Skin users (we visit the forum intermittently to assist with plugin bugs only).', CF7SKINS_TEXTDOMAIN ); ?>
		</li>
	</ul>
	<li><strong><?php _e( 'Add-ons', CF7SKINS_TEXTDOMAIN ); ?></strong></li>
	<ul>
		<li>
		<strong><a href="http://cf7skins.com/support/#premium-email-support?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Premium Email Support', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'available (for current paid licenses) to deal with users questions and problems.', CF7SKINS_TEXTDOMAIN ); ?>
		</li>
	</ul>
</ul>
<p><a href="http://cf7skins.com?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Website', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://kb.cf7skins.com/faq/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'FAQ', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://kb.cf7skins.com/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Documentation', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://kb.cf7skins.com/category/tutorials/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Tutorials', CF7SKINS_TEXTDOMAIN ); ?></a> | <a href="http://cf7skins.com/add-ons/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'Add-ons', CF7SKINS_TEXTDOMAIN ); ?></a></p>

<h2><?php _e( 'Add-ons', CF7SKINS_TEXTDOMAIN ); ?></h2>

<p><?php printf( __( 'Ongoing development of CF7 Skins is made possible by sales of renewable annual licenses of our %1$s.', CF7SKINS_TEXTDOMAIN), '<a href="http://cf7skins.com/add-ons/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank">'. __( 'Add-ons', CF7SKINS_TEXTDOMAIN ) .'</a>' ); ?></p>

<ul>
	<li>
	<strong><a href="http://cf7skins.com/add-ons/pro/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'CF7 Skins Pro', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'Extra Templates & Styles', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://cf7skins.com/add-ons/ready/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'CF7 Skins Ready', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'Useful styling options', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://cf7skins.com/add-ons/multi/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'CF7 Skins Multi', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'Multi-part forms', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
	<li>
	<strong><a href="http://cf7skins.com/add-ons/logic/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><?php _e( 'CF7 Skins Logic', CF7SKINS_TEXTDOMAIN ); ?></a></strong> - <?php _e( 'Conditional logic for your forms', CF7SKINS_TEXTDOMAIN ); ?>
	</li>
</ul>

<p><em><?php _e( 'Our range of', CF7SKINS_TEXTDOMAIN ); ?> <a href="http://cf7skins.com/add-ons/?utm_source=plugin&utm_medium=link&utm_campaign=getting-started"  target="_blank"><strong><?php _ex( 'Add-ons','Subject form. Add conjugations if needed.', CF7SKINS_TEXTDOMAIN ); ?></strong></a> <?php _e( 'brings the functionality available in other premium WordPress form plugins directly within Contact Form 7.', CF7SKINS_TEXTDOMAIN ); ?></em></p>

</div>